/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.object.mask.AdjacentAnyMask;
import com.boydti.fawe.object.mask.AdjacentMask;
import com.boydti.fawe.object.mask.AngleMask;
import com.boydti.fawe.object.mask.BiomeMask;
import com.boydti.fawe.object.mask.BlockLightMask;
import com.boydti.fawe.object.mask.BrightnessMask;
import com.boydti.fawe.object.mask.DataMask;
import com.boydti.fawe.object.mask.ExtremaMask;
import com.boydti.fawe.object.mask.IdDataMask;
import com.boydti.fawe.object.mask.IdMask;
import com.boydti.fawe.object.mask.LightMask;
import com.boydti.fawe.object.mask.OpacityMask;
import com.boydti.fawe.object.mask.ROCAngleMask;
import com.boydti.fawe.object.mask.RadiusMask;
import com.boydti.fawe.object.mask.RandomMask;
import com.boydti.fawe.object.mask.SimplexMask;
import com.boydti.fawe.object.mask.SkyLightMask;
import com.boydti.fawe.object.mask.SurfaceMask;
import com.boydti.fawe.object.mask.WallMask;
import com.boydti.fawe.object.mask.XAxisMask;
import com.boydti.fawe.object.mask.YAxisMask;
import com.boydti.fawe.object.mask.ZAxisMask;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.MethodCommands;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.BlockMaskBuilder;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.ExpressionMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.mask.MaskUnion;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.function.mask.OffsetMask;
import com.sk89q.worldedit.function.mask.RegionMask;
import com.sk89q.worldedit.function.mask.SolidBlockMask;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.regions.shape.WorldEditExpressionEnvironment;
import com.sk89q.worldedit.session.request.RequestSelection;
import com.sk89q.worldedit.util.command.binding.Switch;
import com.sk89q.worldedit.util.command.parametric.Optional;
import com.sk89q.worldedit.world.biome.BaseBiome;

@Command(aliases={"masks"}, desc="Help for the various masks. [More Info](https://git.io/v9r4K)", help="Masks determine if a block can be placed\n - Use [brackets] for arguments\n - Use , to OR multiple\n - Use & to AND multiple\ne.g. >[stone,dirt],#light[0][5],$jungle\nMore Info: https://git.io/v9r4K")
public class MaskCommands
extends MethodCommands {
    public MaskCommands(WorldEdit worldEdit) {
        super(worldEdit);
    }

    @Command(aliases={"#simplex"}, desc="Use simplex noise as the mask", usage="<scale=10> <min=0> <max=100>", min=3, max=3)
    public Mask simplex(double scale, double min, double max) {
        scale = 1.0 / Math.max(1.0, scale);
        min = (min - 50.0) / 50.0;
        max = (max - 50.0) / 50.0;
        return new SimplexMask(scale, min, max);
    }

    @Command(aliases={"#light"}, desc="Restrict to specific light levels", usage="<min> <max>", min=2, max=2)
    public Mask light(Extent extent, double min, double max) {
        return new LightMask(extent, (int)min, (int)max);
    }

    @Command(aliases={"false", "#false"}, desc="Always false")
    public Mask falseMask(Extent extent) {
        return Masks.alwaysFalse();
    }

    @Command(aliases={"true", "#true"}, desc="Always true")
    public Mask trueMask(Extent extent) {
        return Masks.alwaysTrue();
    }

    @Command(aliases={"#skylight"}, desc="Restrict to specific sky light levels", usage="<min> <max>", min=2, max=2)
    public Mask skylight(Extent extent, double min, double max) {
        return new SkyLightMask(extent, (int)min, (int)max);
    }

    @Command(aliases={"#blocklight", "#emittedlight"}, desc="Restrict to specific block light levels", usage="<min> <max>", min=2, max=2)
    public Mask blocklight(Extent extent, double min, double max) {
        return new BlockLightMask(extent, (int)min, (int)max);
    }

    @Command(aliases={"#opacity"}, desc="Restrict to specific opacity levels", usage="<min> <max>", min=2, max=2)
    public Mask opacity(Extent extent, double min, double max) {
        return new OpacityMask(extent, (int)min, (int)max);
    }

    @Command(aliases={"#brightness"}, desc="Restrict to specific block brightness", usage="<min> <max>", min=2, max=2)
    public Mask brightness(Extent extent, double min, double max) {
        return new BrightnessMask(extent, (int)min, (int)max);
    }

    @Command(aliases={"#offset"}, desc="Offset a mask", usage="<dx> <dy> <dz> <mask>", min=4, max=4)
    public Mask offset(double x, double y, double z, Mask mask) {
        return new OffsetMask(mask, new Vector(x, y, z));
    }

    @Command(aliases={"#haslight"}, desc="Restricts to blocks with light (sky or emitted)")
    public Mask haslight(Extent extent) {
        return new LightMask(extent, 1, Integer.MAX_VALUE);
    }

    @Command(aliases={"#nolight"}, desc="Restrict to blocks without light (sky or emitted)")
    public Mask nolight(Extent extent) {
        return new LightMask(extent, 0, 0);
    }

    @Command(aliases={"#existing"}, desc="If there is a non air block")
    public Mask existing(Extent extent) {
        return new ExistingBlockMask(extent);
    }

    @Command(aliases={"#solid"}, desc="If there is a solid block")
    public Mask solid(Extent extent) {
        return new SolidBlockMask(extent);
    }

    @Command(aliases={"#liquid"}, desc="If there is a solid block")
    public Mask liquid(Extent extent) {
        return new BlockMaskBuilder().addAll(b -> b.getMaterial().isLiquid()).build(extent);
    }

    @Command(aliases={"#dregion", "#dselection", "#dsel"}, desc="inside the player's selection")
    public Mask dregion() {
        return new RegionMask(new RequestSelection());
    }

    @Command(aliases={"#region", "#selection", "#sel"}, desc="inside the provided selection")
    public Mask selection(Player player, LocalSession session) throws IncompleteRegionException {
        return new RegionMask(session.getSelection(player.getWorld()).clone());
    }

    @Command(aliases={"#xaxis"}, desc="Restrict to initial x axis")
    public Mask xaxis() {
        return new XAxisMask();
    }

    @Command(aliases={"#yaxis"}, desc="Restrict to initial y axis")
    public Mask yaxis() {
        return new YAxisMask();
    }

    @Command(aliases={"#zaxis"}, desc="Restrict to initial z axis")
    public Mask zaxis() {
        return new ZAxisMask();
    }

    @Command(aliases={"#id"}, desc="Restrict to initial id")
    public Mask id(Extent extent) {
        return new IdMask(extent);
    }

    @Command(aliases={"#data"}, desc="Restrict to initial data")
    public Mask data(Extent extent) {
        return new DataMask(extent);
    }

    @Command(aliases={"#iddata"}, desc="Restrict to initial block id and data")
    public Mask iddata(Extent extent) {
        return new IdDataMask(extent);
    }

    @Command(aliases={"#air"}, desc="Restrict to types of air")
    public Mask air(Extent extent) {
        return new BlockMaskBuilder().addAll(b -> b.getMaterial().isAir()).build(extent);
    }

    @Command(aliases={"#wall"}, desc="Restrict to walls (any block n,e,s,w of air)")
    public Mask wall(Extent extent) {
        Mask blockMask = this.air(extent);
        return new MaskUnion(new ExistingBlockMask(extent), new WallMask(blockMask, 1, 8));
    }

    @Command(aliases={"#surface"}, desc="Restrict to surfaces (any solid block touching air)")
    public Mask surface(Extent extent) {
        return new SurfaceMask(extent);
    }

    @Command(aliases={"\\", "/", "#angle", "#\\", "#/"}, desc="Restrict to specific terrain angle", help="Restrict to specific terrain angle\nThe -o flag will only overlay\nExample: /[0d][45d]\nExplanation: Allows any block where the adjacent block is between 0 and 45 degrees.\nExample: /[3][20]\nExplanation: Allows any block where the adjacent block is between 3 and 20 blocks below", usage="<min> <max> [distance=1]", min=2)
    public Mask angle(Extent extent, String min, String max, @Switch(value=111) boolean overlay, @Optional(value={"1"}) int distance) throws ExpressionException {
        double y2;
        double y1;
        if (max.endsWith("d")) {
            double y1d = Expression.compile(min.substring(0, min.length() - 1), new String[0]).evaluate(new double[0]);
            double y2d = Expression.compile(max.substring(0, max.length() - 1), new String[0]).evaluate(new double[0]);
            y1 = Math.tan(y1d * (Math.PI / 180));
            y2 = Math.tan(y2d * (Math.PI / 180));
        } else {
            y1 = Expression.compile(min, new String[0]).evaluate(new double[0]);
            y2 = Expression.compile(max, new String[0]).evaluate(new double[0]);
        }
        return new AngleMask(extent, y1, y2, overlay, distance);
    }

    @Command(aliases={"(", ")", "#roc", "#(", "#)"}, desc="Restrict to near specific terrain slope rate of change", help="Restrict to near specific terrain slope rate of change\nThe -o flag will only overlay\nExample: ([0d][45d][5]\nExplanation: Restrict near where the angle changes between 0-45 degrees within 5 blocks\nNote: Use negatives for decreasing slope", usage="<min> <max> [distance=4]", min=2)
    public Mask roc(Extent extent, String min, String max, @Switch(value=111) boolean overlay, @Optional(value={"4"}) int distance) throws ExpressionException {
        double y2;
        double y1;
        if (max.endsWith("d")) {
            double y1d = Expression.compile(min.substring(0, min.length() - 1), new String[0]).evaluate(new double[0]);
            double y2d = Expression.compile(max.substring(0, max.length() - 1), new String[0]).evaluate(new double[0]);
            y1 = Math.tan(y1d * (Math.PI / 180));
            y2 = Math.tan(y2d * (Math.PI / 180));
        } else {
            y1 = Expression.compile(min, new String[0]).evaluate(new double[0]);
            y2 = Expression.compile(max, new String[0]).evaluate(new double[0]);
        }
        return new ROCAngleMask(extent, y1, y2, overlay, distance);
    }

    @Command(aliases={"^", "#extrema", "#^"}, desc="Restrict to near specific terrain extrema", help="Restrict to near specific terrain extrema\nThe -o flag will only overlay\nExample: ([0d][45d][5]\nExplanation: Restrict to near 45 degrees of local maxima\nNote: Use negatives for local minima", usage="<min> <max> [distance=1]", min=2, max=4)
    public Mask extrema(Extent extent, String min, String max, @Switch(value=111) boolean overlay, @Optional(value={"4"}) int distance) throws ExpressionException {
        double y2;
        double y1;
        if (max.endsWith("d")) {
            double y1d = Expression.compile(min.substring(0, min.length() - 1), new String[0]).evaluate(new double[0]);
            double y2d = Expression.compile(max.substring(0, max.length() - 1), new String[0]).evaluate(new double[0]);
            y1 = Math.tan(y1d * (Math.PI / 180));
            y2 = Math.tan(y2d * (Math.PI / 180));
        } else {
            y1 = Expression.compile(min, new String[0]).evaluate(new double[0]);
            y2 = Expression.compile(max, new String[0]).evaluate(new double[0]);
        }
        return new ExtremaMask(extent, y1, y2, overlay, distance);
    }

    @Command(aliases={"{", "#{"}, desc="Restricts blocks to within a specific radius range of the initial block", usage="<min> <max>", min=2, max=2)
    public Mask radius(double min, double max) throws ExpressionException {
        return new RadiusMask((int)min, (int)max);
    }

    @Command(aliases={"|", "#|", "#side"}, desc="sides with a specific number of other blocks", usage="<mask> <min> <max>", min=3, max=3)
    public Mask wall(Mask mask, double min, double max) throws ExpressionException {
        return new WallMask(mask, (int)min, (int)max);
    }

    @Command(aliases={"~", "#~", "#adjacent"}, desc="Adjacent to a specific number of other blocks", usage="<mask> [min=1] [max=8]", min=1, max=3)
    public Mask adjacent(Mask mask, @Optional(value={"-1"}) double min, @Optional(value={"-1"}) double max) throws ExpressionException {
        if (min == -1.0 && max == -1.0) {
            min = 1.0;
            max = 8.0;
        } else if (max == -1.0) {
            max = min;
        }
        if (max >= 8.0 && min == 1.0) {
            return new AdjacentAnyMask(mask);
        }
        return new AdjacentMask(mask, (int)min, (int)max);
    }

    @Command(aliases={"<", "#<", "#below"}, desc="below a specific block", usage="<mask>", min=1, max=1)
    public Mask below(Mask mask) throws ExpressionException {
        OffsetMask offsetMask = new OffsetMask(mask, new Vector(0, 1, 0));
        return new MaskIntersection(offsetMask, Masks.negate(mask));
    }

    @Command(aliases={">", "#>", "#above"}, desc="above a specific block", usage="<mask>", min=1, max=1)
    public Mask above(Mask mask) throws ExpressionException {
        OffsetMask offsetMask = new OffsetMask(mask, new Vector(0, -1, 0));
        return new MaskIntersection(offsetMask, Masks.negate(mask));
    }

    @Command(aliases={"$", "#biome", "#$"}, desc="in a specific biome", help="in a specific biome. For a list of biomes use //biomelist", usage="<biome>", min=1, max=1)
    public Mask biome(Extent extent, BaseBiome biome) throws ExpressionException {
        return new BiomeMask(extent, biome);
    }

    @Command(aliases={"%", "#%", "#percent"}, desc="percentage chance", usage="<chance>", min=1, max=1)
    public Mask random(double chance) throws ExpressionException {
        return new RandomMask(chance /= 100.0);
    }

    @Command(aliases={"=", "#=", "#expression"}, desc="expression mask", usage="<expression>", min=1, max=1)
    public Mask expression(Extent extent, String input) throws ExpressionException {
        Expression exp = Expression.compile(input, "x", "y", "z");
        WorldEditExpressionEnvironment env = new WorldEditExpressionEnvironment(extent, Vector.ONE, Vector.ZERO);
        exp.setEnvironment(env);
        return new ExpressionMask(exp);
    }

    @Command(aliases={"!", "#not", "#negate", "#!"}, desc="Negate another mask", usage="<mask>", min=1, max=1)
    public Mask expression(Mask mask) throws ExpressionException {
        return Masks.negate(mask);
    }
}

