/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.SetQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public abstract class TaskManager {
    public static TaskManager IMP;
    private ForkJoinPool pool = new ForkJoinPool();

    public abstract int repeat(Runnable var1, int var2);

    public abstract int repeatAsync(Runnable var1, int var2);

    public abstract void async(Runnable var1);

    public abstract void task(Runnable var1);

    public ForkJoinPool getPublicForkJoinPool() {
        return this.pool;
    }

    public void parallel(Collection<Runnable> runnables) {
        for (Runnable run : runnables) {
            this.pool.submit(run);
        }
        this.pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public void parallel(Collection<Runnable> runnables, @Nullable Integer numThreads) {
        if (runnables == null) {
            return;
        }
        if (numThreads == null) {
            numThreads = Settings.IMP.QUEUE.PARALLEL_THREADS;
        }
        if (numThreads <= 1) {
            for (Runnable run : runnables) {
                if (run == null) continue;
                run.run();
            }
            return;
        }
        int numRuns = runnables.size();
        int amountPerThread = 1 + numRuns / numThreads;
        Runnable[][] split = new Runnable[numThreads.intValue()][amountPerThread];
        Thread[] threads = new Thread[numThreads.intValue()];
        int i = 0;
        int j = 0;
        Thread[] threadArray = runnables.iterator();
        while (threadArray.hasNext()) {
            Runnable run;
            split[i][j] = run = threadArray.next();
            if (++i < numThreads) continue;
            i = 0;
            ++j;
        }
        for (i = 0; i < threads.length; ++i) {
            final Runnable[] toRun = split[i];
            Thread thread = threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int j = 0; j < toRun.length; ++j) {
                        Runnable run = toRun[j];
                        if (run == null) continue;
                        run.run();
                    }
                }
            });
            thread.start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void runUnsafe(FaweQueue queue, Runnable run) {
        queue.startSet(true);
        try {
            run.run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        queue.endSet(true);
    }

    public void taskNow(Runnable r, boolean async) {
        if (async) {
            this.async(r);
        } else if (r != null) {
            r.run();
        }
    }

    public void taskNowMain(Runnable r) {
        if (r == null) {
            return;
        }
        if (Fawe.isMainThread()) {
            r.run();
        } else {
            this.task(r);
        }
    }

    public void taskNowAsync(Runnable r) {
        this.taskNow(r, Fawe.isMainThread());
    }

    public void taskSoonMain(Runnable r, boolean async) {
        if (async) {
            this.async(r);
        } else {
            this.task(r);
        }
    }

    public abstract void later(Runnable var1, int var2);

    public abstract void laterAsync(Runnable var1, int var2);

    public abstract void cancel(int var1);

    public <T> void objectTask(Collection<T> objects, final RunnableVal<T> task, final Runnable whenDone) {
        final Iterator<T> iterator = objects.iterator();
        this.task(new Runnable(){

            @Override
            public void run() {
                boolean hasNext;
                long start = System.currentTimeMillis();
                while ((hasNext = iterator.hasNext()) && System.currentTimeMillis() - start < 5L) {
                    task.value = iterator.next();
                    task.run();
                }
                if (!hasNext) {
                    TaskManager.this.later(whenDone, 1);
                } else {
                    TaskManager.this.later(this, 1);
                }
            }
        });
    }

    public <T> T sync(RunnableVal<T> function) {
        return this.sync(function, Integer.MAX_VALUE);
    }

    public <T> T sync(Supplier<T> function) {
        return this.sync(function, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(AtomicBoolean running, int timout) {
        try {
            long start = System.currentTimeMillis();
            AtomicBoolean atomicBoolean = running;
            synchronized (atomicBoolean) {
                while (running.get()) {
                    running.wait(timout);
                    if (!running.get() || System.currentTimeMillis() - start <= (long)Settings.IMP.QUEUE.DISCARD_AFTER_MS) continue;
                    new RuntimeException("FAWE is taking a long time to execute a task (might just be a symptom): ").printStackTrace();
                    Fawe.debug("For full debug information use: /fawe threads");
                }
            }
        }
        catch (InterruptedException e) {
            MainUtil.handleError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(AtomicBoolean running) {
        running.set(false);
        AtomicBoolean atomicBoolean = running;
        synchronized (atomicBoolean) {
            running.notifyAll();
        }
    }

    public <T> T syncWhenFree(RunnableVal<T> function) {
        return this.syncWhenFree(function, Integer.MAX_VALUE);
    }

    public void taskWhenFree(Runnable run) {
        if (Fawe.isMainThread()) {
            run.run();
        } else {
            SetQueue.IMP.addTask(run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T syncWhenFree(final RunnableVal<T> function, int timeout) {
        if (Fawe.isMainThread()) {
            function.run();
            return function.value;
        }
        final AtomicBoolean running = new AtomicBoolean(true);
        RunnableVal<RuntimeException> run = new RunnableVal<RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RuntimeException value) {
                try {
                    function.run();
                }
                catch (RuntimeException e) {
                    this.value = e;
                }
                catch (Throwable neverHappens) {
                    MainUtil.handleError(neverHappens);
                }
                finally {
                    running.set(false);
                }
                RunnableVal runnableVal = function;
                synchronized (runnableVal) {
                    function.notifyAll();
                }
            }
        };
        SetQueue.IMP.addTask(run);
        try {
            RunnableVal<T> runnableVal = function;
            synchronized (runnableVal) {
                while (running.get()) {
                    function.wait(timeout);
                }
            }
        }
        catch (InterruptedException e) {
            MainUtil.handleError(e);
        }
        if (run.value != null) {
            throw (RuntimeException)run.value;
        }
        return function.value;
    }

    public <T> T sync(RunnableVal<T> function, int timeout) {
        return this.sync((Supplier<T>)function, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T sync(final Supplier<T> function, int timeout) {
        if (Fawe.isMainThread()) {
            return function.get();
        }
        final AtomicBoolean running = new AtomicBoolean(true);
        RunnableVal<Object> run = new RunnableVal<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(Object value) {
                try {
                    this.value = function.get();
                }
                catch (RuntimeException e) {
                    this.value = e;
                }
                catch (Throwable neverHappens) {
                    MainUtil.handleError(neverHappens);
                }
                finally {
                    running.set(false);
                    Supplier e = function;
                    synchronized (e) {
                        function.notifyAll();
                    }
                }
            }
        };
        SetQueue.IMP.addTask(run);
        try {
            Supplier<T> supplier = function;
            synchronized (supplier) {
                while (running.get()) {
                    function.wait(timeout);
                }
            }
        }
        catch (InterruptedException e) {
            MainUtil.handleError(e);
        }
        if (run.value != null && run.value instanceof RuntimeException) {
            throw (RuntimeException)run.value;
        }
        return run.value;
    }
}

