/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.ReflectionUtils;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import java.lang.reflect.Field;

public class ExtentTraverser<T extends Extent> {
    private T root;
    private ExtentTraverser<T> parent;

    public ExtentTraverser(T root) {
        this(root, null);
    }

    public ExtentTraverser(T root, ExtentTraverser<T> parent) {
        this.root = root;
        this.parent = parent;
    }

    public boolean exists() {
        return this.root != null;
    }

    public T get() {
        return this.root;
    }

    public boolean setNext(T next) {
        try {
            Field field = AbstractDelegateExtent.class.getDeclaredField("extent");
            ReflectionUtils.setFailsafeFieldValue(field, this.root, next);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public ExtentTraverser<T> last() {
        ExtentTraverser<T> last = this;
        for (ExtentTraverser<T> traverser = this; traverser != null && traverser.get() instanceof AbstractDelegateExtent; traverser = traverser.next()) {
            last = traverser;
        }
        return last;
    }

    public boolean insert(T extent) {
        try {
            Field field = AbstractDelegateExtent.class.getDeclaredField("extent");
            field.setAccessible(true);
            field.set(extent, field.get(this.root));
            field.set(this.root, extent);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public <U> U findAndGet(Class<U> clazz) {
        ExtentTraverser<U> traverser = this.find(clazz);
        return traverser != null ? (U)traverser.get() : null;
    }

    public <U extends Extent> ExtentTraverser<U> find(Class<U> clazz) {
        try {
            for (ExtentTraverser<T> value = this; value != null; value = value.next()) {
                if (!clazz.isAssignableFrom(value.root.getClass())) continue;
                return value;
            }
            return null;
        }
        catch (Throwable e) {
            MainUtil.handleError(e);
            return null;
        }
    }

    public <U extends Extent> ExtentTraverser<U> find(Object object) {
        try {
            for (ExtentTraverser<T> value = this; value != null; value = value.next()) {
                if (value.root != object) continue;
                return value;
            }
            return null;
        }
        catch (Throwable e) {
            MainUtil.handleError(e);
            return null;
        }
    }

    public ExtentTraverser<T> previous() {
        return this.parent;
    }

    public ExtentTraverser<T> next() {
        try {
            if (this.root instanceof AbstractDelegateExtent) {
                Field field = AbstractDelegateExtent.class.getDeclaredField("extent");
                field.setAccessible(true);
                Extent value = (Extent)field.get(this.root);
                if (value == null) {
                    return null;
                }
                return new ExtentTraverser<Extent>(value, this);
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

