/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.boydti.fawe.object.pattern.AbstractExtentPattern;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.regions.Region;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;

public class FullClipboardPattern
extends AbstractExtentPattern {
    private final Clipboard clipboard;
    private final MutableBlockVector mutable = new MutableBlockVector();

    public FullClipboardPattern(Extent extent, Clipboard clipboard) {
        super(extent);
        Preconditions.checkNotNull((Object)clipboard);
        this.clipboard = clipboard;
    }

    @Override
    public boolean apply(Extent extent, Vector setPosition, Vector getPosition) throws WorldEditException {
        Region region = this.clipboard.getRegion();
        ForwardExtentCopy copy = new ForwardExtentCopy(this.clipboard, this.clipboard.getRegion(), this.clipboard.getOrigin(), extent, setPosition);
        copy.setSourceMask(new ExistingBlockMask(this.clipboard));
        Operations.completeBlindly(copy);
        return true;
    }

    @Override
    public BaseBlock apply(Vector position) {
        throw new IllegalStateException("Incorrect use. This pattern can only be applied to an extent!");
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException("Clipboard cannot be serialized!");
    }
}

