/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class TemporalExtent
extends AbstractDelegateExtent {
    private int x;
    private int y;
    private int z = Integer.MAX_VALUE;
    private BlockState block = EditSession.nullBlock;
    private int bx;
    private int bz = Integer.MAX_VALUE;
    private BaseBiome biome = EditSession.nullBiome;

    public TemporalExtent(Extent extent) {
        super(extent);
    }

    public void set(int x, int y, int z, BlockStateHolder block) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.block = (BlockState)block;
    }

    public void set(int x, int z, BaseBiome biome) {
        this.bx = x;
        this.bz = z;
        this.biome = biome;
    }

    @Override
    public int getBrightness(int x, int y, int z) {
        if (this.x == x && this.y == y && this.z == z) {
            return Math.min(15, this.block.getBlockType().getMaterial().getLightValue());
        }
        return super.getBrightness(x, y, z);
    }

    @Override
    public BlockState getBlock(Vector position) {
        if (position.getX() == (double)this.x && position.getY() == (double)this.y && position.getZ() == (double)this.z) {
            return this.block;
        }
        return super.getBlock(position);
    }

    @Override
    public BlockState getLazyBlock(Vector position) {
        if (position.getX() == (double)this.x && position.getY() == (double)this.y && position.getZ() == (double)this.z) {
            return this.block;
        }
        return super.getLazyBlock(position);
    }

    @Override
    public BlockState getLazyBlock(int x, int y, int z) {
        if (this.x == x && this.y == y && this.z == z) {
            return this.block;
        }
        return super.getLazyBlock(x, y, z);
    }

    @Override
    public BaseBiome getBiome(Vector2D position) {
        if (position.getX() == (double)this.bx && position.getZ() == (double)this.bz) {
            return this.biome;
        }
        return super.getBiome(position);
    }
}

