/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.brush.ResettableTool;
import com.boydti.fawe.object.brush.visualization.VisualExtent;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.function.pattern.Pattern;

public class LineBrush
implements Brush,
ResettableTool {
    private final boolean shell;
    private final boolean select;
    private final boolean flat;
    private Vector pos1;

    public LineBrush(boolean shell, boolean select, boolean flat) {
        this.shell = shell;
        this.select = select;
        this.flat = flat;
    }

    @Override
    public void build(EditSession editSession, Vector position, Pattern pattern, double size) throws MaxChangedBlocksException {
        boolean visual = editSession.getExtent() instanceof VisualExtent;
        if (this.pos1 == null) {
            if (!visual) {
                this.pos1 = position;
                BBC.BRUSH_LINE_PRIMARY.send(editSession.getPlayer(), position);
            }
            return;
        }
        editSession.drawLine(pattern, this.pos1, position, size, !this.shell, this.flat);
        if (!visual) {
            BBC.BRUSH_LINE_SECONDARY.send(editSession.getPlayer(), new Object[0]);
            if (!this.select) {
                this.pos1 = null;
                return;
            }
            this.pos1 = position;
        }
    }

    @Override
    public boolean reset() {
        this.pos1 = null;
        return true;
    }
}

