/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt.anvil.filters;

import com.boydti.fawe.jnbt.anvil.MCAFilterCounter;
import com.boydti.fawe.object.number.MutableLong;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public class DeleteOldFilter
extends MCAFilterCounter {
    private final long time;

    public DeleteOldFilter(long time) {
        this.time = time;
        if (time < 1L) {
            throw new IllegalArgumentException("Time must be positive");
        }
    }

    @Override
    public boolean appliesFile(Path path, BasicFileAttributes attr) {
        long modified = attr.lastModifiedTime().toMillis();
        long last = modified;
        if (last != 0L && System.currentTimeMillis() - last > this.time) {
            path.toFile().delete();
            ((MutableLong)this.get()).add(0x4000000L);
        }
        return false;
    }
}

