/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.exception.FaweException;
import com.sk89q.jnbt.NBTInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class NBTStreamer {
    private final NBTInputStream is;
    private final Map<String, BiConsumer> readers;

    public NBTStreamer(NBTInputStream stream) {
        this.is = stream;
        this.readers = new HashMap<String, BiConsumer>();
    }

    public NBTStreamer(NBTInputStream stream, Map<String, BiConsumer> readers) {
        this.is = stream;
        this.readers = readers;
    }

    public void readFully() throws IOException {
        this.is.readNamedTagLazy(node -> this.readers.get(node));
        this.is.close();
    }

    public void readQuick() throws IOException {
        try {
            this.is.readNamedTagLazy(node -> {
                if (this.readers.isEmpty()) {
                    throw new FaweException(BBC.WORLDEDIT_CANCEL_REASON_MANUAL);
                }
                return this.readers.remove(node);
            });
        }
        catch (FaweException faweException) {
            // empty catch block
        }
        this.is.close();
    }

    public <T, V> void addReader(String node, BiConsumer<T, V> run) {
        if (run instanceof NBTStreamReader) {
            ((NBTStreamReader)run).init(node);
        }
        this.readers.put(node, run);
    }

    public <T, V> void addReader(BiConsumer<T, V> run, String ... nodes) {
        for (String node : nodes) {
            this.addReader(node, run);
        }
    }

    public static abstract class LongReader
    implements BiConsumer<Integer, Long> {
        @Override
        public void accept(Integer index, Long value) {
            this.run(index, value);
        }

        public abstract void run(int var1, long var2);
    }

    public static abstract class LazyReader
    implements BiConsumer<Integer, DataInputStream> {
    }

    public static abstract class ByteReader
    implements BiConsumer<Integer, Integer> {
        @Override
        public void accept(Integer index, Integer value) {
            this.run(index, value);
        }

        public abstract void run(int var1, int var2);
    }

    public static abstract class NBTStreamReader<T, V>
    implements BiConsumer<T, V> {
        private String node;

        public void init(String node) {
            this.node = node;
        }

        public String getNode() {
            return this.node;
        }
    }
}

