/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.database;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.logging.rollback.RollbackOptimizedHistory;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.changeset.DiskStorageHistory;
import com.boydti.fawe.object.task.AsyncNotifyQueue;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.TaskManager;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class RollbackDatabase
extends AsyncNotifyQueue {
    private final String prefix;
    private final File dbLocation;
    private final String worldName;
    private final World world;
    private Connection connection;
    private String INSERT_EDIT;
    private String CREATE_TABLE;
    private String GET_EDITS;
    private String GET_EDITS_USER;
    private String GET_EDITS_ASC;
    private String GET_EDITS_USER_ASC;
    private String DELETE_EDITS_USER;
    private String DELETE_EDIT_USER;
    private String PURGE;
    private ConcurrentLinkedQueue<RollbackOptimizedHistory> historyChanges = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> tasks = new ConcurrentLinkedQueue();

    public RollbackDatabase(String world) throws SQLException, ClassNotFoundException {
        this(FaweAPI.getWorld(world));
    }

    public RollbackDatabase(World world) throws SQLException, ClassNotFoundException {
        this.prefix = "";
        this.worldName = Fawe.imp().getWorldName(world);
        this.world = world;
        this.dbLocation = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HISTORY + File.separator + Fawe.imp().getWorldName(world) + File.separator + "summary.db");
        this.connection = this.openConnection();
        this.CREATE_TABLE = "CREATE TABLE IF NOT EXISTS `" + this.prefix + "edits` (`player` BLOB(16) NOT NULL,`id` INT NOT NULL,`x1` INT NOT NULL,`y1` INT NOT NULL,`z1` INT NOT NULL,`x2` INT NOT NULL,`y2` INT NOT NULL,`z2` INT NOT NULL,`time` INT NOT NULL, PRIMARY KEY (player, id))";
        this.INSERT_EDIT = "INSERT OR REPLACE INTO `" + this.prefix + "edits` (`player`,`id`,`x1`,`y1`,`z1`,`x2`,`y2`,`z2`,`time`) VALUES(?,?,?,?,?,?,?,?,?)";
        this.PURGE = "DELETE FROM `" + this.prefix + "edits` WHERE `time`<?";
        this.GET_EDITS = "SELECT `player`,`id` FROM `" + this.prefix + "edits` WHERE `x2`>=? AND `x1`<=? AND `y2`>=? AND `y1`<=? AND `z2`>=? AND `z1`<=? AND `time`>? ORDER BY `time` DESC, `id` DESC";
        this.GET_EDITS_USER = "SELECT `player`,`id` FROM `" + this.prefix + "edits` WHERE `x2`>=? AND `x1`<=? AND `y2`>=? AND `y1`<=? AND `z2`>=? AND `z1`<=? AND `time`>? AND `player`=? ORDER BY `time` DESC, `id` DESC";
        this.GET_EDITS_ASC = "SELECT `player`,`id` FROM `" + this.prefix + "edits` WHERE `x2`>=? AND `x1`<=? AND `y2`>=? AND `y1`<=? AND `z2`>=? AND `z1`<=? AND `time`>? ORDER BY `time` ASC, `id` ASC";
        this.GET_EDITS_USER_ASC = "SELECT `player`,`id` FROM `" + this.prefix + "edits` WHERE `x2`>=? AND `x1`<=? AND `y2`>=? AND `y1`<=? AND `z2`>=? AND `z1`<=? AND `time`>? AND `player`=? ORDER BY `time` ASC, `id` ASC";
        this.DELETE_EDITS_USER = "DELETE FROM `" + this.prefix + "edits` WHERE `x2`>=? AND `x1`<=? AND `y2`>=? AND `y1`<=? AND `z2`>=? AND `z1`<=? AND `time`>? AND `player`=?";
        this.DELETE_EDIT_USER = "DELETE FROM `" + this.prefix + "edits` WHERE `player`=? AND `id`=?";
        this.init();
        this.purge((int)TimeUnit.DAYS.toMillis(Settings.IMP.HISTORY.DELETE_AFTER_DAYS));
    }

    @Override
    public boolean hasQueued() {
        return this.connection != null && (!this.historyChanges.isEmpty() || !this.tasks.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void operate() {
        RollbackDatabase rollbackDatabase = this;
        synchronized (rollbackDatabase) {
            if (this.connection == null) {
                return;
            }
            while (this.sendBatch()) {
            }
        }
    }

    public void init() {
        try (PreparedStatement stmt = this.connection.prepareStatement(this.CREATE_TABLE);){
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(final UUID uuid, final int id) {
        this.addTask(new Runnable(){

            @Override
            public void run() {
                try (PreparedStatement stmt = RollbackDatabase.this.connection.prepareStatement(RollbackDatabase.this.DELETE_EDIT_USER);){
                    byte[] uuidBytes = ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
                    stmt.setBytes(1, uuidBytes);
                    stmt.setInt(2, id);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void purge(int diff) {
        long now = System.currentTimeMillis() / 1000L;
        final int then = (int)(now - (long)diff);
        this.addTask(new Runnable(){

            @Override
            public void run() {
                try (PreparedStatement stmt = RollbackDatabase.this.connection.prepareStatement(RollbackDatabase.this.PURGE);){
                    stmt.setInt(1, then);
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void getPotentialEdits(final UUID uuid, final long minTime, final Vector pos1, final Vector pos2, final RunnableVal<DiskStorageHistory> onEach, final Runnable whenDone, final boolean delete, final boolean ascending) {
        final World world = FaweAPI.getWorld(this.worldName);
        this.addTask(new Runnable(){

            @Override
            public void run() {
                byte[] uuidBytes;
                Throwable throwable;
                PreparedStatement stmt;
                String stmtStr = ascending ? (uuid == null ? RollbackDatabase.this.GET_EDITS_ASC : RollbackDatabase.this.GET_EDITS_USER_ASC) : (uuid == null ? RollbackDatabase.this.GET_EDITS : RollbackDatabase.this.GET_EDITS_USER);
                try {
                    stmt = RollbackDatabase.this.connection.prepareStatement(stmtStr);
                    throwable = null;
                    try {
                        ResultSet result;
                        stmt.setInt(1, pos1.getBlockX());
                        stmt.setInt(2, pos2.getBlockX());
                        stmt.setByte(3, (byte)(pos1.getBlockY() - 128));
                        stmt.setByte(4, (byte)(pos2.getBlockY() - 128));
                        stmt.setInt(5, pos1.getBlockZ());
                        stmt.setInt(6, pos2.getBlockZ());
                        stmt.setInt(7, (int)(minTime / 1000L));
                        if (uuid != null) {
                            uuidBytes = ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
                            stmt.setBytes(8, uuidBytes);
                        }
                        if (!(result = stmt.executeQuery()).next()) {
                            TaskManager.IMP.taskNow(whenDone, false);
                            return;
                        }
                        do {
                            long low;
                            byte[] uuidBytes2 = result.getBytes(1);
                            int index = result.getInt(2);
                            ByteBuffer bb = ByteBuffer.wrap(uuidBytes2);
                            long high = bb.getLong();
                            DiskStorageHistory history = new DiskStorageHistory(world, new UUID(high, low = bb.getLong()), index);
                            if (!history.getBDFile().exists()) continue;
                            onEach.run(history);
                        } while (result.next());
                        TaskManager.IMP.taskNow(whenDone, false);
                    }
                    catch (Throwable result) {
                        throwable = result;
                        throw result;
                    }
                    finally {
                        if (stmt != null) {
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (delete && uuid != null) {
                    try {
                        stmt = RollbackDatabase.this.connection.prepareStatement(RollbackDatabase.this.DELETE_EDITS_USER);
                        throwable = null;
                        try {
                            stmt.setInt(1, pos1.getBlockX());
                            stmt.setInt(2, pos2.getBlockX());
                            stmt.setByte(3, (byte)(pos1.getBlockY() - 128));
                            stmt.setByte(4, (byte)(pos2.getBlockY() - 128));
                            stmt.setInt(5, pos1.getBlockZ());
                            stmt.setInt(6, pos2.getBlockZ());
                            stmt.setInt(7, (int)(minTime / 1000L));
                            uuidBytes = ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
                            stmt.setBytes(8, uuidBytes);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (stmt != null) {
                                if (throwable != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    stmt.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void logEdit(RollbackOptimizedHistory history) {
        this.queue(() -> this.historyChanges.add(history));
    }

    public void addTask(Runnable run) {
        this.queue(() -> this.tasks.add(run));
    }

    private void runTasks() {
        Runnable task;
        while ((task = this.tasks.poll()) != null) {
            try {
                task.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean sendBatch() {
        try {
            int size;
            this.runTasks();
            this.commit();
            if (this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(false);
            }
            if ((size = Math.min(1048572, this.historyChanges.size())) == 0) {
                return false;
            }
            RollbackOptimizedHistory[] copy = new RollbackOptimizedHistory[size];
            for (int i = 0; i < size; ++i) {
                copy[i] = this.historyChanges.poll();
            }
            try (PreparedStatement stmt = this.connection.prepareStatement(this.INSERT_EDIT);){
                for (RollbackOptimizedHistory change : copy) {
                    UUID uuid = change.getUUID();
                    byte[] uuidBytes = ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
                    stmt.setBytes(1, uuidBytes);
                    stmt.setInt(2, change.getIndex());
                    stmt.setInt(3, change.getMinX());
                    stmt.setByte(4, (byte)(change.getMinY() - 128));
                    stmt.setInt(5, change.getMinZ());
                    stmt.setInt(6, change.getMaxX());
                    stmt.setByte(7, (byte)(change.getMaxY() - 128));
                    stmt.setInt(8, change.getMaxZ());
                    stmt.setInt(9, (int)(change.getTime() / 1000L));
                    stmt.executeUpdate();
                    stmt.clearParameters();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.commit();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void commit() {
        try {
            if (this.connection == null) {
                return;
            }
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Connection openConnection() throws SQLException, ClassNotFoundException {
        if (this.checkConnection()) {
            return this.connection;
        }
        if (!Fawe.imp().getDirectory().exists()) {
            Fawe.imp().getDirectory().mkdirs();
        }
        if (!this.dbLocation.exists()) {
            try {
                this.dbLocation.getParentFile().mkdirs();
                this.dbLocation.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                Fawe.debug("&cUnable to create database!");
            }
        }
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbLocation);
        return this.connection;
    }

    public Connection forceConnection() throws SQLException, ClassNotFoundException {
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbLocation);
        return this.connection;
    }

    public Connection getConnection() {
        if (this.connection == null) {
            try {
                this.forceConnection();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConnection() throws SQLException {
        if (this.connection == null) {
            return false;
        }
        RollbackDatabase rollbackDatabase = this;
        synchronized (rollbackDatabase) {
            if (this.connection == null) {
                return false;
            }
            this.connection.close();
            this.connection = null;
            return true;
        }
    }

    public boolean checkConnection() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }
}

