/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.configuration.file;

import com.boydti.fawe.configuration.Configuration;
import com.boydti.fawe.configuration.InvalidConfigurationException;
import com.boydti.fawe.configuration.MemoryConfiguration;
import com.boydti.fawe.configuration.file.FileConfigurationOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public abstract class FileConfiguration
extends MemoryConfiguration {
    public FileConfiguration() {
    }

    public FileConfiguration(Configuration defaults) {
        super(defaults);
    }

    public void save(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File cannot be null");
        }
        file.getParentFile().mkdirs();
        String data = this.saveToString();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            writer.write(data);
        }
    }

    public void save(String file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File cannot be null");
        }
        this.save(new File(file));
    }

    public abstract String saveToString();

    public void load(File file) throws IOException, InvalidConfigurationException {
        if (file == null) {
            throw new NullPointerException("File cannot be null");
        }
        FileInputStream stream = new FileInputStream(file);
        this.load(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
    }

    public void load(Reader reader) throws IOException, InvalidConfigurationException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line;
            while ((line = input.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
        }
        this.loadFromString(builder.toString());
    }

    public void load(String file) throws IOException, InvalidConfigurationException {
        if (file == null) {
            throw new NullPointerException("File cannot be null");
        }
        this.load(new File(file));
    }

    public abstract void loadFromString(String var1) throws InvalidConfigurationException;

    protected abstract String buildHeader();

    @Override
    public FileConfigurationOptions options() {
        if (this.options == null) {
            this.options = new FileConfigurationOptions(this);
        }
        return (FileConfigurationOptions)this.options;
    }
}

