/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.wrapper;

import com.boydti.fawe.bukkit.wrapper.AsyncBlock;
import com.boydti.fawe.bukkit.wrapper.AsyncWorld;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class AsyncBlockState
implements BlockState {
    private int combinedId;
    private BlockData blockData;
    private CompoundTag nbt;
    private final AsyncBlock block;

    public AsyncBlockState(AsyncBlock block) {
        this(block, block.queue.getCombinedId4Data(block.x, block.y, block.z, 0));
    }

    public AsyncBlockState(AsyncBlock block, int combined) {
        this.combinedId = combined;
        this.block = block;
        this.blockData = BukkitAdapter.getBlockData(combined);
        if (BlockTypes.getFromStateId(combined).getMaterial().hasContainer()) {
            this.nbt = block.queue.getTileEntity(block.x, block.y, block.z);
        }
    }

    public int getTypeId() {
        return this.combinedId & BlockTypes.BIT_MASK;
    }

    public int getPropertyId() {
        return this.combinedId >> BlockTypes.BIT_OFFSET;
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockData getBlockData() {
        return this.blockData;
    }

    public MaterialData getData() {
        return new MaterialData(this.blockData.getMaterial());
    }

    public Material getType() {
        return this.blockData.getMaterial();
    }

    public byte getLightLevel() {
        return (byte)BlockTypes.getFromStateId(this.combinedId).getMaterial().getLightValue();
    }

    public AsyncWorld getWorld() {
        return this.block.world;
    }

    public int getX() {
        return this.block.x;
    }

    public int getY() {
        return this.block.y;
    }

    public int getZ() {
        return this.block.z;
    }

    public Location getLocation() {
        return this.block.getLocation();
    }

    public Location getLocation(Location loc) {
        return this.block.getLocation(loc);
    }

    public Chunk getChunk() {
        return this.block.getChunk();
    }

    public void setData(MaterialData data) {
        this.setBlockData(data.getItemType().createBlockData());
    }

    public void setBlockData(BlockData blockData) {
        this.blockData = blockData;
        this.combinedId = BukkitAdapter.adapt(blockData).getInternalId();
    }

    public void setType(Material type) {
        this.setBlockData(type.createBlockData());
    }

    public boolean update() {
        return this.update(false);
    }

    public boolean update(boolean force) {
        return this.update(force, true);
    }

    public boolean update(boolean force, boolean applyPhysics) {
        try {
            boolean result = this.block.queue.setBlock(this.block.x, this.block.y, this.block.z, BukkitAdapter.adapt(this.blockData));
            if (this.nbt != null) {
                this.block.queue.setTile(this.block.x, this.block.y, this.block.z, this.nbt);
            }
            return result;
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
    }

    public CompoundTag getNbtData() {
        return this.nbt;
    }

    public void setNbtData(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public byte getRawData() {
        return (byte)(this.combinedId >> BlockTypes.BIT_OFFSET);
    }

    public void setRawData(byte data) {
        this.combinedId = (this.combinedId & BlockTypes.BIT_MASK) + (data << BlockTypes.BIT_OFFSET);
        this.blockData = BukkitAdapter.getBlockData(this.combinedId);
    }

    public boolean isPlaced() {
        return true;
    }

    public void setMetadata(String key, MetadataValue value) {
        this.block.setMetadata(key, value);
    }

    public List<MetadataValue> getMetadata(String key) {
        return this.block.getMetadata(key);
    }

    public boolean hasMetadata(String key) {
        return this.block.hasMetadata(key);
    }

    public void removeMetadata(String key, Plugin plugin) {
        this.block.removeMetadata(key, plugin);
    }
}

