/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.adapter.v1_13_1;

import com.sk89q.util.ReflectionUtil;
import com.sk89q.worldedit.blocks.BlockMaterial;
import net.minecraft.server.v1_13_R2.Block;
import net.minecraft.server.v1_13_R2.EnumPistonReaction;
import net.minecraft.server.v1_13_R2.IBlockData;
import net.minecraft.server.v1_13_R2.ITileEntity;
import net.minecraft.server.v1_13_R2.Material;
import org.bukkit.craftbukkit.v1_13_R2.block.data.CraftBlockData;

public class BlockMaterial_1_13
implements BlockMaterial {
    private final Block block;
    private final IBlockData defaultState;
    private final Material material;
    private final boolean isTranslucent;
    private final CraftBlockData craftBlockData;

    public BlockMaterial_1_13(Block block) {
        this(block, block.getBlockData());
    }

    public BlockMaterial_1_13(Block block, IBlockData defaultState) {
        this.block = block;
        this.defaultState = defaultState;
        this.material = defaultState.getMaterial();
        this.craftBlockData = CraftBlockData.fromData((IBlockData)defaultState);
        this.isTranslucent = (Boolean)ReflectionUtil.getField(Block.class, block, "n");
    }

    public Block getBlock() {
        return this.block;
    }

    public IBlockData getState() {
        return this.defaultState;
    }

    public CraftBlockData getCraftBlockData() {
        return this.craftBlockData;
    }

    public Material getMaterial() {
        return this.material;
    }

    @Override
    public boolean isAir() {
        return this.defaultState.isAir();
    }

    @Override
    public boolean isFullCube() {
        return this.defaultState.g();
    }

    @Override
    public boolean isOpaque() {
        return this.material.f();
    }

    @Override
    public boolean isPowerSource() {
        return this.defaultState.isPowerSource();
    }

    @Override
    public boolean isLiquid() {
        return this.material.isLiquid();
    }

    @Override
    public boolean isSolid() {
        return this.material.isBuildable();
    }

    @Override
    public float getHardness() {
        return this.block.strength;
    }

    @Override
    public float getResistance() {
        return this.block.getDurability();
    }

    @Override
    public float getSlipperiness() {
        return this.block.n();
    }

    @Override
    public int getLightValue() {
        return this.defaultState.e();
    }

    @Override
    public int getLightOpacity() {
        return this.isTranslucent() ? 15 : 0;
    }

    @Override
    public boolean isFragileWhenPushed() {
        return this.material.getPushReaction() == EnumPistonReaction.DESTROY;
    }

    @Override
    public boolean isUnpushable() {
        return this.material.getPushReaction() == EnumPistonReaction.BLOCK;
    }

    @Override
    public boolean isTicksRandomly() {
        return this.block.isTicking(this.defaultState);
    }

    @Override
    public boolean isMovementBlocker() {
        return this.material.isSolid();
    }

    @Override
    public boolean isBurnable() {
        return this.material.isBurnable();
    }

    @Override
    public boolean isToolRequired() {
        return !this.material.isAlwaysDestroyable();
    }

    @Override
    public boolean isReplacedDuringPlacement() {
        return this.material.isReplaceable();
    }

    @Override
    public boolean isTranslucent() {
        return this.isTranslucent;
    }

    @Override
    public boolean hasContainer() {
        return this.block instanceof ITileEntity;
    }

    @Override
    public int getMapColor() {
        return this.material.i().rgb;
    }
}

