/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe;

import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongArrayTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.world.biome.BaseBiome;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FaweCache {
    public static final short[][][] CACHE_I;
    public static final short[][][] CACHE_J;
    public static final byte[][] CACHE_X;
    public static final short[][] CACHE_Y;
    public static final byte[][] CACHE_Z;
    public static final BaseBiome[] CACHE_BIOME;

    public static final BaseBiome getBiome(int id) {
        return CACHE_BIOME[id];
    }

    public static Map<String, Object> asMap(Object ... pairs) {
        HashMap<String, Object> map = new HashMap<String, Object>(pairs.length >> 1);
        for (int i = 0; i < pairs.length; i += 2) {
            String key = (String)pairs[i];
            Object value = pairs[i + 1];
            map.put(key, value);
        }
        return map;
    }

    public static ShortTag asTag(short value) {
        return new ShortTag(value);
    }

    public static IntTag asTag(int value) {
        return new IntTag(value);
    }

    public static DoubleTag asTag(double value) {
        return new DoubleTag(value);
    }

    public static ByteTag asTag(byte value) {
        return new ByteTag(value);
    }

    public static FloatTag asTag(float value) {
        return new FloatTag(value);
    }

    public static LongTag asTag(long value) {
        return new LongTag(value);
    }

    public static ByteArrayTag asTag(byte[] value) {
        return new ByteArrayTag(value);
    }

    public static IntArrayTag asTag(int[] value) {
        return new IntArrayTag(value);
    }

    public static LongArrayTag asTag(long[] value) {
        return new LongArrayTag(value);
    }

    public static StringTag asTag(String value) {
        return new StringTag(value);
    }

    public static CompoundTag asTag(Map<String, Object> value) {
        HashMap<String, Tag> map = new HashMap<String, Tag>();
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            Object child = entry.getValue();
            Tag tag = FaweCache.asTag(child);
            map.put(entry.getKey(), tag);
        }
        return new CompoundTag(map);
    }

    public static Tag asTag(Object value) {
        if (value instanceof Integer) {
            return FaweCache.asTag((Integer)value);
        }
        if (value instanceof Short) {
            return FaweCache.asTag((Short)value);
        }
        if (value instanceof Double) {
            return FaweCache.asTag((Double)value);
        }
        if (value instanceof Byte) {
            return FaweCache.asTag((Byte)value);
        }
        if (value instanceof Float) {
            return FaweCache.asTag(((Float)value).floatValue());
        }
        if (value instanceof Long) {
            return FaweCache.asTag((Long)value);
        }
        if (value instanceof String) {
            return FaweCache.asTag((String)value);
        }
        if (value instanceof Map) {
            return FaweCache.asTag((Map)value);
        }
        if (value instanceof Collection) {
            return FaweCache.asTag((Collection)value);
        }
        if (value instanceof Object[]) {
            return FaweCache.asTag((Object[])value);
        }
        if (value instanceof byte[]) {
            return FaweCache.asTag((byte[])value);
        }
        if (value instanceof int[]) {
            return FaweCache.asTag((int[])value);
        }
        if (value instanceof long[]) {
            return FaweCache.asTag((long[])value);
        }
        if (value instanceof Tag) {
            return (Tag)value;
        }
        if (value instanceof Boolean) {
            return FaweCache.asTag((byte)((Boolean)value != false ? 1 : 0));
        }
        if (value == null) {
            System.out.println("Invalid nbt: " + value);
            return null;
        }
        Class<?> clazz = value.getClass();
        if (clazz.getName().startsWith("com.intellectualcrafters.jnbt")) {
            try {
                if (clazz.getName().equals("com.intellectualcrafters.jnbt.EndTag")) {
                    return EndTag.INSTANCE;
                }
                Field field = clazz.getDeclaredField("value");
                field.setAccessible(true);
                return FaweCache.asTag(field.get(value));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        System.out.println("Invalid nbt: " + value);
        return null;
    }

    public static ListTag asTag(Object ... values) {
        Class clazz = null;
        ArrayList<Tag> list = new ArrayList<Tag>(values.length);
        for (Object value : values) {
            Tag tag = FaweCache.asTag(value);
            if (clazz == null) {
                clazz = tag.getClass();
            }
            list.add(tag);
        }
        if (clazz == null) {
            clazz = EndTag.class;
        }
        return new ListTag<EndTag>(clazz, list);
    }

    public static ListTag asTag(Collection values) {
        Class clazz = null;
        ArrayList<Tag> list = new ArrayList<Tag>(values.size());
        for (Object value : values) {
            Tag tag = FaweCache.asTag(value);
            if (clazz == null) {
                clazz = tag.getClass();
            }
            list.add(tag);
        }
        if (clazz == null) {
            clazz = EndTag.class;
        }
        return new ListTag<EndTag>(clazz, list);
    }

    static {
        int y;
        int z;
        int x;
        CACHE_I = new short[256][16][16];
        CACHE_J = new short[256][16][16];
        CACHE_X = new byte[16][];
        CACHE_Y = new short[16][4096];
        CACHE_Z = new byte[16][];
        CACHE_BIOME = new BaseBiome[256];
        for (int i = 0; i < 256; ++i) {
            FaweCache.CACHE_BIOME[i] = new BaseBiome(i){

                @Override
                public void setId(int id) {
                    throw new IllegalStateException("Cannot set id");
                }
            };
        }
        FaweCache.CACHE_X[0] = new byte[4096];
        FaweCache.CACHE_Z[0] = new byte[4096];
        for (int y2 = 0; y2 < 16; ++y2) {
            FaweCache.CACHE_X[y2] = CACHE_X[0];
            FaweCache.CACHE_Z[y2] = CACHE_Z[0];
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                for (y = 0; y < 16; ++y) {
                    short j = (short)((y & 0xF) << 8 | z << 4 | x);
                    FaweCache.CACHE_X[0][j] = (byte)x;
                    FaweCache.CACHE_Z[0][j] = (byte)z;
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                for (y = 0; y < 256; ++y) {
                    short i = (short)(y >> 4);
                    short j = (short)((y & 0xF) << 8 | z << 4 | x);
                    FaweCache.CACHE_I[y][z][x] = i;
                    FaweCache.CACHE_J[y][z][x] = j;
                    FaweCache.CACHE_Y[i][j] = (short)y;
                }
            }
        }
    }
}

