/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.io.IOException;
import java.io.InputStream;
import net.jpountz.lz4.LZ4Decompressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4StreamHelper;

public class LZ4InputStream
extends InputStream {
    private static LZ4Factory factory = LZ4Factory.fastestInstance();
    private final InputStream inputStream;
    private final LZ4Decompressor decompressor = factory.decompressor();
    private byte[] compressedBuffer;
    private byte[] decompressedBuffer;
    private int decompressedBufferPosition = 0;
    private int decompressedBufferLength = 0;

    public LZ4InputStream(InputStream stream) {
        this(stream, 0x100000);
    }

    public LZ4InputStream(InputStream stream, int size) {
        this.inputStream = stream;
        this.compressedBuffer = new byte[size];
        this.decompressedBuffer = new byte[size];
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public int read() throws IOException {
        if (this.ensureBytesAvailableInDecompressedBuffer()) {
            return this.decompressedBuffer[this.decompressedBufferPosition++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int numBytesRemainingToRead;
        int numBytesToRead;
        if (!this.ensureBytesAvailableInDecompressedBuffer()) {
            return -1;
        }
        for (numBytesRemainingToRead = len - off; numBytesRemainingToRead > 0 && this.ensureBytesAvailableInDecompressedBuffer(); numBytesRemainingToRead -= numBytesToRead) {
            numBytesToRead = numBytesRemainingToRead;
            int numBytesRemainingInBlock = this.decompressedBufferLength - this.decompressedBufferPosition;
            if (numBytesToRead > numBytesRemainingInBlock) {
                numBytesToRead = numBytesRemainingInBlock;
            }
            System.arraycopy(this.decompressedBuffer, this.decompressedBufferPosition, b, off, numBytesToRead);
            this.decompressedBufferPosition += numBytesToRead;
            off += numBytesToRead;
        }
        return len - numBytesRemainingToRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long numBytesRemainingToSkip;
        long numBytesToSkip;
        for (numBytesRemainingToSkip = n; numBytesRemainingToSkip > 0L && this.ensureBytesAvailableInDecompressedBuffer(); numBytesRemainingToSkip -= numBytesToSkip) {
            numBytesToSkip = numBytesRemainingToSkip;
            int numBytesRemainingInBlock = this.decompressedBufferLength - this.decompressedBufferPosition;
            if (numBytesToSkip > (long)numBytesRemainingInBlock) {
                numBytesToSkip = numBytesRemainingInBlock;
            }
            this.decompressedBufferPosition = (int)((long)this.decompressedBufferPosition + numBytesToSkip);
        }
        return n - numBytesRemainingToSkip;
    }

    private boolean ensureBytesAvailableInDecompressedBuffer() throws IOException {
        while (this.decompressedBufferPosition >= this.decompressedBufferLength) {
            if (this.fillBuffer()) continue;
            return false;
        }
        return true;
    }

    private boolean fillBuffer() throws IOException {
        this.decompressedBufferLength = LZ4StreamHelper.readLength(this.inputStream);
        int compressedBufferLength = LZ4StreamHelper.readLength(this.inputStream);
        if (this.blockHeadersIndicateNoMoreData(compressedBufferLength, this.decompressedBufferLength)) {
            return false;
        }
        this.ensureBufferCapacity(compressedBufferLength, this.decompressedBufferLength);
        if (this.fillCompressedBuffer(compressedBufferLength)) {
            this.decompressor.decompress(this.compressedBuffer, 0, this.decompressedBuffer, 0, this.decompressedBufferLength);
            this.decompressedBufferPosition = 0;
            return true;
        }
        return false;
    }

    private boolean blockHeadersIndicateNoMoreData(int compressedBufferLength, int decompressedBufferLength) {
        return compressedBufferLength < 0 || decompressedBufferLength < 0;
    }

    private boolean fillCompressedBuffer(int compressedBufferLength) throws IOException {
        int bytesReadInAttempt;
        for (int bytesRead = 0; bytesRead < compressedBufferLength; bytesRead += bytesReadInAttempt) {
            bytesReadInAttempt = this.inputStream.read(this.compressedBuffer, bytesRead, compressedBufferLength - bytesRead);
            if (bytesReadInAttempt >= 0) continue;
            return false;
        }
        return true;
    }

    private void ensureBufferCapacity(int compressedBufferLength, int decompressedBufferLength) {
        if (compressedBufferLength > this.compressedBuffer.length) {
            this.compressedBuffer = new byte[compressedBufferLength];
        }
        if (decompressedBufferLength > this.decompressedBuffer.length) {
            this.decompressedBuffer = new byte[decompressedBufferLength];
        }
    }
}

