/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.entity;

import com.boydti.fawe.util.ReflectionUtils;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.world.entity.EntityType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nullable;

public enum EntityTypes implements EntityType
{
    __RESERVED__,
    AREA_EFFECT_CLOUD,
    ARMOR_STAND,
    ARROW,
    BAT,
    BLAZE,
    BOAT,
    CAVE_SPIDER,
    CHEST_MINECART,
    CHICKEN,
    COD,
    COMMAND_BLOCK_MINECART,
    COW,
    CREEPER,
    DOLPHIN,
    DONKEY,
    DRAGON_FIREBALL,
    DROWNED,
    EGG,
    ELDER_GUARDIAN,
    END_CRYSTAL,
    ENDER_DRAGON,
    ENDER_PEARL,
    ENDERMAN,
    ENDERMITE,
    EVOKER,
    EVOKER_FANGS,
    EXPERIENCE_BOTTLE,
    EXPERIENCE_ORB,
    EYE_OF_ENDER,
    FALLING_BLOCK,
    FIREBALL,
    FIREWORK_ROCKET,
    FISHING_BOBBER,
    FURNACE_MINECART,
    GHAST,
    GIANT,
    GUARDIAN,
    HOPPER_MINECART,
    HORSE,
    HUSK,
    ILLUSIONER,
    IRON_GOLEM,
    ITEM,
    ITEM_FRAME,
    LEASH_KNOT,
    LIGHTNING_BOLT,
    LLAMA,
    LLAMA_SPIT,
    MAGMA_CUBE,
    MINECART,
    MOOSHROOM,
    MULE,
    OCELOT,
    PAINTING,
    PARROT,
    PHANTOM,
    PIG,
    PLAYER,
    POLAR_BEAR,
    POTION,
    PUFFERFISH,
    RABBIT,
    SALMON,
    SHEEP,
    SHULKER,
    SHULKER_BULLET,
    SILVERFISH,
    SKELETON,
    SKELETON_HORSE,
    SLIME,
    SMALL_FIREBALL,
    SNOW_GOLEM,
    SNOWBALL,
    SPAWNER_MINECART,
    SPECTRAL_ARROW,
    SPIDER,
    SQUID,
    STRAY,
    TNT,
    TNT_MINECART,
    TRIDENT,
    TROPICAL_FISH,
    TURTLE,
    VEX,
    VILLAGER,
    VINDICATOR,
    WITCH,
    WITHER,
    WITHER_SKELETON,
    WITHER_SKULL,
    WOLF,
    ZOMBIE,
    ZOMBIE_HORSE,
    ZOMBIE_PIGMAN,
    ZOMBIE_VILLAGER;

    private String id;
    private int internalId;
    private static final Map<String, EntityTypes> $REGISTRY;
    private static int $LENGTH;
    public static final EntityTypes[] values;

    private EntityTypes() {
        this(null);
    }

    private EntityTypes(String id) {
        this.init(id);
    }

    private void init(String id) {
        if (id == null) {
            id = "minecraft:" + this.name().toLowerCase();
        } else if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        this.id = id;
        this.internalId = this.ordinal();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public int getInternalId() {
        return this.internalId;
    }

    public static EntityType parse(String id) {
        if (id.startsWith("minecraft:")) {
            id = id.substring(10);
        }
        switch (id) {
            case "FallingSand": {
                return FALLING_BLOCK;
            }
            case "FireworksRocketEntity": {
                return FIREWORK_ROCKET;
            }
            case "LavaSlime": {
                return MAGMA_CUBE;
            }
            case "MinecartChest": {
                return CHEST_MINECART;
            }
            case "MinecartCommandBlock": {
                return COMMAND_BLOCK_MINECART;
            }
            case "MinecartFurnace": {
                return FURNACE_MINECART;
            }
            case "MinecartHopper": {
                return HOPPER_MINECART;
            }
            case "MinecartRideable": {
                return MINECART;
            }
            case "MinecartSpawner": {
                return SPAWNER_MINECART;
            }
            case "MinecartTNT": {
                return TNT_MINECART;
            }
            case "MushroomCow": {
                return MOOSHROOM;
            }
            case "PigZombie": {
                return ZOMBIE_PIGMAN;
            }
            case "PrimedTnt": {
                return TNT;
            }
            case "SnowMan": {
                return SNOW_GOLEM;
            }
            case "ThrownEgg": {
                return EGG;
            }
            case "ThrownEnderpearl": {
                return ENDER_PEARL;
            }
            case "ThrownExpBottle": {
                return EXPERIENCE_BOTTLE;
            }
            case "ThrownPotion": {
                return POTION;
            }
            case "WitherBoss": {
                return WITHER;
            }
            case "XPOrb": {
                return EXPERIENCE_ORB;
            }
        }
        if (Character.isUpperCase(id.charAt(0))) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if (Character.isUpperCase(c)) {
                    c = Character.toLowerCase(c);
                    if (i != 0) {
                        result.append('_');
                    }
                }
                result.append(c);
            }
            return EntityTypes.parse(result.toString());
        }
        switch (id.toLowerCase()) {
            case "xp_orb": {
                return EXPERIENCE_ORB;
            }
            case "xp_bottle": {
                return EXPERIENCE_BOTTLE;
            }
            case "eye_of_ender_signal": {
                return EYE_OF_ENDER;
            }
            case "ender_crystal": {
                return END_CRYSTAL;
            }
            case "fireworks_rocket": {
                return FIREWORK_ROCKET;
            }
            case "commandblock_minecart": {
                return COMMAND_BLOCK_MINECART;
            }
            case "snowman": {
                return SNOW_GOLEM;
            }
            case "villager_golem": {
                return IRON_GOLEM;
            }
            case "evocation_fangs": {
                return EVOKER_FANGS;
            }
            case "evocation_illager": {
                return EVOKER;
            }
            case "vindication_illager": {
                return VINDICATOR;
            }
            case "illusion_illager": {
                return ILLUSIONER;
            }
        }
        return EntityTypes.get(id);
    }

    private static EntityTypes register(String id) {
        int propStart = id.indexOf(91);
        String typeName = id.substring(0, propStart == -1 ? id.length() : propStart);
        String enumName = (typeName.startsWith("minecraft:") ? typeName.substring(10) : typeName).toUpperCase();
        EntityTypes existing = null;
        try {
            existing = EntityTypes.valueOf(enumName.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (existing == null) {
            existing = ReflectionUtils.addEnum(EntityTypes.class, enumName);
        }
        int internalId = existing.ordinal();
        if (existing.id == null) {
            existing.init(null);
        }
        if (internalId == 0 && existing != __RESERVED__) {
            existing.internalId = $LENGTH++;
        }
        if (typeName.startsWith("minecraft:")) {
            $REGISTRY.put(typeName.substring(10), existing);
        }
        $REGISTRY.put(typeName, existing);
        return existing;
    }

    @Nullable
    public static final EntityTypes get(String id) {
        return $REGISTRY.get(id);
    }

    @Deprecated
    public static final EntityTypes get(int ordinal) {
        return values[ordinal];
    }

    public static int size() {
        return values.length;
    }

    static {
        $REGISTRY = new HashMap<String, EntityTypes>();
        try {
            Collection<String> ents = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getEntityRegistry().registerEntities();
            EntityTypes[] oldValues = EntityTypes.values();
            $LENGTH = oldValues.length;
            LinkedHashSet<EntityTypes> newValues = new LinkedHashSet<EntityTypes>(Arrays.asList(oldValues));
            if (!ents.isEmpty()) {
                for (String ent : ents) {
                    EntityTypes registered = EntityTypes.register(ent);
                    if (newValues.contains(registered)) continue;
                    newValues.add(registered);
                }
            }
            values = newValues.toArray(new EntityTypes[newValues.size()]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

