/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.boydti.fawe.command.SuggestInputParseException;
import com.boydti.fawe.object.string.MutableCharSequence;
import com.google.common.collect.Maps;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.SingleBlockStateMask;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class BlockState
implements BlockStateHolder<BlockState> {
    @Deprecated
    public static BlockState getFromInternalId(int combinedId) throws InputParseException {
        return BlockTypes.getFromStateId(combinedId).withStateId(combinedId);
    }

    @Deprecated
    public static BlockState getFromOrdinal(int ordinal) {
        return BlockTypes.states[ordinal];
    }

    public static BlockState get(String state) throws InputParseException {
        return BlockState.get(null, state);
    }

    public static BlockState get(@Nullable BlockType type, String state) throws InputParseException {
        return BlockState.get(type, state, null);
    }

    public static BlockState get(@Nullable BlockType type, String state, BlockState defaultState) throws InputParseException {
        int last;
        MutableCharSequence charSequence;
        int propStrStart = state.indexOf(91);
        if (type == null) {
            CharSequence key;
            if (propStrStart == -1) {
                key = state;
            } else {
                charSequence = MutableCharSequence.getTemporal();
                charSequence.setString(state);
                charSequence.setSubstring(0, propStrStart);
                key = charSequence;
            }
            type = BlockTypes.get(key);
            if (type == null) {
                String input = key.toString();
                throw new SuggestInputParseException("Does not match a valid block type: " + input, input, () -> Stream.of(BlockTypes.values).filter(b -> b.getId().contains(input)).map(e1 -> e1.getId()).collect(Collectors.toList()));
            }
        }
        if (propStrStart == -1) {
            return type.getDefaultState();
        }
        List<? extends Property> propList = type.getProperties();
        if (state.charAt(state.length() - 1) != ']') {
            state = state + "]";
        }
        charSequence = MutableCharSequence.getTemporal();
        charSequence.setString(state);
        if (propList.size() == 1) {
            AbstractProperty property = (AbstractProperty)propList.get(0);
            String name = property.getName();
            charSequence.setSubstring(propStrStart + name.length() + 2, state.length() - 1);
            return type.withPropertyId(property.getIndexFor(charSequence));
        }
        int stateId = defaultState != null ? defaultState.getInternalId() : type.getInternalId();
        int length = state.length();
        Property property = null;
        block4: for (int i = last = propStrStart + 1; i < length; ++i) {
            char c = state.charAt(i);
            switch (c) {
                case ',': 
                case ']': {
                    int index;
                    charSequence.setSubstring(last, i);
                    if (property != null) {
                        index = property.getIndexFor(charSequence);
                        if (index == -1) {
                            String input = charSequence.toString();
                            List values = ((AbstractProperty)property).getValues();
                            throw new SuggestInputParseException("No value: " + input + " for " + type, input, () -> values.stream().map(v -> v.toString()).filter(v -> v.startsWith(input)).collect(Collectors.toList()));
                        }
                    } else {
                        PropertyKey key = PropertyKey.get(charSequence);
                        if (key == null || !type.hasProperty(key)) {
                            String input = charSequence.toString();
                            BlockType finalType = type;
                            throw new SuggestInputParseException("Invalid property " + type + " | " + input, input, () -> finalType.getProperties().stream().map(p -> p.getName()).filter(p -> p.startsWith(input)).collect(Collectors.toList()));
                        }
                        throw new SuggestInputParseException("No operator for " + state, "", () -> Arrays.asList("="));
                    }
                    stateId = ((AbstractProperty)property).modifyIndex(stateId, index);
                    property = null;
                    last = i + 1;
                    continue block4;
                }
                case '=': {
                    charSequence.setSubstring(last, i);
                    property = (AbstractProperty)type.getPropertyMap().get(charSequence);
                    last = i + 1;
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return type.withPropertyId(stateId >> BlockTypes.BIT_OFFSET);
    }

    @Override
    public BlockState withPropertyId(int propertyId) {
        return this.getBlockType().withPropertyId(propertyId);
    }

    @Override
    public Mask toMask(Extent extent) {
        return new SingleBlockStateMask(extent, this);
    }

    @Override
    public boolean apply(Extent extent, Vector get, Vector set) throws WorldEditException {
        return extent.setBlock(set, this);
    }

    @Override
    public BlockState apply(Vector position) {
        return this;
    }

    @Override
    public boolean hasNbtData() {
        return this.getNbtData() != null;
    }

    @Override
    public String getNbtId() {
        return "";
    }

    @Override
    @Nullable
    public CompoundTag getNbtData() {
        return null;
    }

    @Override
    public void setNbtData(@Nullable CompoundTag nbtData) {
        throw new UnsupportedOperationException("This class is immutable.");
    }

    @Override
    @Deprecated
    public final int getInternalPropertiesId() {
        return this.getInternalId() >> BlockTypes.BIT_OFFSET;
    }

    @Override
    @Deprecated
    public final int getInternalBlockTypeId() {
        return this.getInternalId() & BlockTypes.BIT_MASK;
    }

    @Override
    public <V> BlockState with(Property<V> property, V value) {
        try {
            BlockTypes type = this.getBlockType();
            int newState = ((AbstractProperty)property).modify(this.getInternalId(), value);
            return newState != this.getInternalId() ? type.withStateId(newState) : this;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Property not found: " + property);
        }
    }

    @Override
    public <V> BlockState with(PropertyKey property, V value) {
        try {
            BlockTypes type = this.getBlockType();
            int newState = ((AbstractProperty)type.getProperty(property)).modify(this.getInternalId(), value);
            return newState != this.getInternalId() ? type.withStateId(newState) : this;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Property not found: " + (Object)((Object)property));
        }
    }

    @Override
    public final <V> V getState(Property<V> property) {
        try {
            AbstractProperty ap = (AbstractProperty)property;
            return (V)ap.getValue(this.getInternalId());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Property not found: " + property);
        }
    }

    @Override
    @Deprecated
    public final <V> V getState(PropertyKey key) {
        return this.getState(this.getBlockType().getProperty(key));
    }

    @Override
    @Deprecated
    public final Map<Property<?>, Object> getStates() {
        BlockTypes type = this.getBlockType();
        Map map = Maps.asMap(type.getPropertiesSet(), input -> this.getState((Property)input));
        return map;
    }

    @Deprecated
    public BlockState toFuzzy() {
        return this;
    }

    public int hashCode() {
        return this.getOrdinal();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    @Deprecated
    public boolean equalsFuzzy(BlockStateHolder o) {
        return o.getOrdinal() == this.getOrdinal();
    }

    @Override
    public BlockState toImmutableState() {
        return this;
    }

    public String toString() {
        return this.getAsString();
    }
}

