/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world;

import com.boydti.fawe.util.SetQueue;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import javax.annotation.Nullable;

public interface SimpleWorld
extends World {
    @Override
    default public boolean useItem(Vector position, BaseItem item, Direction face) {
        return false;
    }

    @Override
    default public boolean setBlock(Vector position, BlockStateHolder block, boolean notifyAndLight) throws WorldEditException {
        return this.setBlock(position, block);
    }

    @Override
    default public BlockState getFullBlock(Vector position) {
        return this.getLazyBlock(position);
    }

    @Override
    public boolean setBlock(Vector var1, BlockStateHolder var2) throws WorldEditException;

    @Override
    default public int getMaxY() {
        return this.getMaximumPoint().getBlockY();
    }

    @Override
    default public Mask createLiquidMask() {
        return new BlockTypeMask((Extent)this, BlockTypes.LAVA, BlockTypes.WATER);
    }

    @Override
    default public void dropItem(Vector pt, BaseItemStack item, int times) {
        for (int i = 0; i < times; ++i) {
            this.dropItem(pt, item);
        }
    }

    @Override
    default public void checkLoadedChunk(Vector pt) {
    }

    @Override
    default public void fixAfterFastMode(Iterable<BlockVector2D> chunks) {
    }

    @Override
    default public void fixLighting(Iterable<BlockVector2D> chunks) {
    }

    @Override
    default public boolean playEffect(Vector position, int type, int data) {
        return false;
    }

    @Override
    default public boolean queueBlockBreakEffect(Platform server, Vector position, BlockType blockType, double priority) {
        SetQueue.IMP.addTask(() -> this.playEffect(position, 2001, blockType.getLegacyCombinedId() >> 4));
        return true;
    }

    @Override
    default public Vector getMinimumPoint() {
        return new Vector(-30000000, 0, -30000000);
    }

    @Override
    default public Vector getMaximumPoint() {
        return new Vector(30000000, 255, 30000000);
    }

    @Override
    @Nullable
    default public Operation commit() {
        return null;
    }

    @Override
    default public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, Vector position) throws MaxChangedBlocksException {
        return false;
    }

    @Override
    default public void simulateBlockMine(Vector position) {
        try {
            this.setBlock(position, BlockTypes.AIR.getDefaultState());
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    default public WeatherType getWeather() {
        return WeatherTypes.CLEAR;
    }

    @Override
    default public long getRemainingWeatherDuration() {
        return 0L;
    }

    @Override
    default public void setWeather(WeatherType weatherType) {
    }

    @Override
    default public void setWeather(WeatherType weatherType, long duration) {
    }
}

