/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.formatting.component;

import com.boydti.fawe.config.BBC;
import com.google.common.base.Preconditions;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.worldedit.extension.platform.CommandManager;
import com.sk89q.worldedit.util.command.CommandCallable;
import com.sk89q.worldedit.util.command.CommandMapping;
import com.sk89q.worldedit.util.command.Description;
import com.sk89q.worldedit.util.command.Dispatcher;
import com.sk89q.worldedit.util.command.PrimaryAliasComparator;
import com.sk89q.worldedit.util.formatting.Style;
import com.sk89q.worldedit.util.formatting.StyledFragment;
import com.sk89q.worldedit.util.formatting.component.CommandListBox;
import com.sk89q.worldedit.util.formatting.component.Label;
import com.sk89q.worldedit.util.formatting.component.MessageBox;
import com.sk89q.worldedit.util.formatting.component.Subtle;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;

public class CommandUsageBox
extends StyledFragment {
    public CommandUsageBox(CommandCallable command, String commandString) {
        this(command, commandString, null);
    }

    public CommandUsageBox(CommandCallable command, String commandString, @Nullable CommandLocals locals) {
        Preconditions.checkNotNull((Object)command);
        Preconditions.checkNotNull((Object)commandString);
        if (command instanceof Dispatcher) {
            this.attachDispatcherUsage((Dispatcher)command, commandString, locals);
        } else {
            this.attachCommandUsage(command.getDescription(), commandString);
        }
    }

    private void attachDispatcherUsage(Dispatcher dispatcher, String commandString, @Nullable CommandLocals locals) {
        CommandListBox box = new CommandListBox(BBC.HELP_HEADER_SUBCOMMANDS.f(new Object[0]));
        String prefix = !commandString.isEmpty() ? commandString + " " : "";
        ArrayList<CommandMapping> list = new ArrayList<CommandMapping>(dispatcher.getCommands());
        Collections.sort(list, new PrimaryAliasComparator(CommandManager.COMMAND_CLEAN_PATTERN));
        for (CommandMapping mapping : list) {
            boolean perm = locals == null || mapping.getCallable().testPermission(locals);
            box.appendCommand(prefix + mapping.getPrimaryAlias(), mapping.getDescription().getDescription(), perm);
        }
        this.append(box);
    }

    private void attachCommandUsage(Description description, String commandString) {
        MessageBox box = new MessageBox(BBC.HELP_HEADER_COMMAND.f(commandString));
        StyledFragment contents = box.getContents();
        if (description.getUsage() != null) {
            contents.append(new Label().append(BBC.COMMAND_SYNTAX.f(description.getUsage())));
        } else {
            contents.createFragment(Style.GRAY);
            contents.append(new Subtle().append("Usage information is not available."));
        }
        contents.newLine();
        contents.createFragment(Style.GRAY);
        if (description.getHelp() != null) {
            contents.append(description.getHelp());
        } else if (description.getDescription() != null) {
            contents.append(description.getDescription());
        } else {
            contents.append(new Subtle().append("No further help is available."));
        }
        this.append(box);
    }
}

