/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.command.parametric;

import com.google.common.primitives.Chars;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.minecraft.util.commands.WrappedCommandException;
import com.sk89q.worldedit.util.command.CommandCallable;
import com.sk89q.worldedit.util.command.InvalidUsageException;
import com.sk89q.worldedit.util.command.MissingParameterException;
import com.sk89q.worldedit.util.command.Parameter;
import com.sk89q.worldedit.util.command.SimpleDescription;
import com.sk89q.worldedit.util.command.SimpleParameter;
import com.sk89q.worldedit.util.command.UnconsumedParameterException;
import com.sk89q.worldedit.util.command.binding.Switch;
import com.sk89q.worldedit.util.command.parametric.AParametricCallable;
import com.sk89q.worldedit.util.command.parametric.ArgumentStack;
import com.sk89q.worldedit.util.command.parametric.ContextArgumentStack;
import com.sk89q.worldedit.util.command.parametric.InvokeHandler;
import com.sk89q.worldedit.util.command.parametric.InvokeListener;
import com.sk89q.worldedit.util.command.parametric.Optional;
import com.sk89q.worldedit.util.command.parametric.ParameterData;
import com.sk89q.worldedit.util.command.parametric.ParameterException;
import com.sk89q.worldedit.util.command.parametric.ParametricBuilder;
import com.sk89q.worldedit.util.command.parametric.ParametricException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ParametricCallable
extends AParametricCallable {
    private final ParametricBuilder builder;
    private final Object object;
    private final Method method;
    private final ParameterData[] parameters;
    private final Set<Character> valueFlags = new HashSet<Character>();
    private final boolean anyFlags;
    private final Set<Character> legacyFlags = new HashSet<Character>();
    private final SimpleDescription description = new SimpleDescription();
    private final CommandPermissions commandPermissions;
    private final Command definition;

    public ParametricCallable(ParametricBuilder builder, Object object, Method method, Command definition) throws ParametricException {
        this.builder = builder;
        this.object = object;
        this.method = method;
        Annotation[][] annotations = method.getParameterAnnotations();
        String[] names = builder.getParanamer().lookupParameterNames(method, false);
        Type[] types = method.getGenericParameterTypes();
        this.parameters = new ParameterData[types.length];
        ArrayList<Parameter> userParameters = new ArrayList<Parameter>();
        int numOptional = 0;
        CommandPermissions permHint = method.getAnnotation(CommandPermissions.class);
        if (permHint != null) {
            this.description.setPermissions(Arrays.asList(permHint.value()));
        }
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            ParameterData parameter = new ParameterData();
            parameter.setType(type);
            parameter.setModifiers(annotations[i]);
            for (Annotation annotation : annotations[i]) {
                if (annotation instanceof Switch) {
                    parameter.setFlag(Character.valueOf(((Switch)annotation).value()), type != Boolean.TYPE);
                    continue;
                }
                if (annotation instanceof Optional) {
                    parameter.setOptional(true);
                    String[] value = ((Optional)annotation).value();
                    if (value.length <= 0) continue;
                    parameter.setDefaultValue(value);
                    continue;
                }
                if (parameter.getBinding() != null) continue;
                parameter.setBinding(builder.getBindings().get(annotation.annotationType()));
                parameter.setClassifier(annotation);
            }
            parameter.setName(names.length > 0 ? names[i] : ParametricCallable.generateName(type, parameter.getClassifier(), i));
            if (parameter.isValueFlag()) {
                this.valueFlags.add(parameter.getFlag());
            }
            if (parameter.getBinding() == null) {
                parameter.setBinding(builder.getBindings().get(type));
                if (parameter.getBinding() == null) {
                    throw new ParametricException("Don't know how to handle the parameter type '" + type + "' in\n" + method.toGenericString());
                }
            }
            parameter.validate(method, i + 1);
            if (parameter.isOptional() && parameter.getFlag() == null) {
                ++numOptional;
            } else if (numOptional > 0 && parameter.isNonFlagConsumer() && parameter.getConsumedCount() < 0) {
                throw new ParametricException("Found an parameter using the binding " + parameter.getBinding().getClass().getCanonicalName() + "\nthat does not know how many arguments it consumes, but " + "it follows an optional parameter\nMethod: " + method.toGenericString());
            }
            this.parameters[i] = parameter;
            if (!parameter.isUserInput()) continue;
            userParameters.add(parameter);
        }
        this.anyFlags = definition.anyFlags();
        this.legacyFlags.addAll(Chars.asList((char[])definition.flags().toCharArray()));
        this.description.setDescription(!definition.desc().isEmpty() ? definition.desc() : null);
        this.description.setHelp(!definition.help().isEmpty() ? definition.help() : null);
        this.description.overrideUsage(!definition.usage().isEmpty() ? definition.usage() : null);
        for (InvokeListener listener : builder.getInvokeListeners()) {
            listener.updateDescription(object, method, this.parameters, this.description);
        }
        this.description.setParameters(userParameters);
        this.commandPermissions = method.getAnnotation(CommandPermissions.class);
        this.definition = definition;
    }

    @Override
    public Command getCommand() {
        return this.object.getClass().getAnnotation(Command.class);
    }

    @Override
    public Command getDefinition() {
        return this.definition;
    }

    @Override
    public String getGroup() {
        return this.object.getClass().getSimpleName().replaceAll("Commands", "").replaceAll("Util$", "");
    }

    @Override
    public Object call(String stringArguments, CommandLocals locals, String[] parentCommands) throws CommandException {
        if (parentCommands.length != 0 && !this.testPermission(locals)) {
            throw new CommandPermissionsException();
        }
        locals.putIfAbsent(CommandCallable.class, this);
        String calledCommand = parentCommands.length > 0 ? parentCommands[parentCommands.length - 1] : "_";
        String[] split = (calledCommand + " " + stringArguments).split(" ", -1);
        CommandContext context = new CommandContext(split, this.getValueFlags(), false, locals);
        if (context.hasFlag('?')) {
            throw new InvalidUsageException(null, this, true);
        }
        Object[] args = new Object[this.parameters.length];
        ContextArgumentStack arguments = new ContextArgumentStack(context);
        SimpleParameter parameter = null;
        try {
            ArrayList<InvokeHandler> handlers = new ArrayList<InvokeHandler>();
            for (InvokeListener listener : this.builder.getInvokeListeners()) {
                InvokeHandler handler = listener.createInvokeHandler();
                handlers.add(handler);
                handler.preProcess(this.object, this.method, this.parameters, context);
            }
            for (int i = 0; i < this.parameters.length; ++i) {
                parameter = this.parameters[i];
                if (this.mayConsumeArguments(i, arguments)) {
                    ArgumentStack usedArguments = ParametricCallable.getScopedContext(parameter, arguments);
                    try {
                        usedArguments.mark();
                        args[i] = ((ParameterData)parameter).getBinding().bind((ParameterData)parameter, usedArguments, false);
                    }
                    catch (ParameterException e) {
                        if (!parameter.isOptional()) {
                            throw e;
                        }
                        usedArguments.reset();
                        args[i] = this.getDefaultValue(i, arguments);
                    }
                    continue;
                }
                args[i] = this.getDefaultValue(i, arguments);
            }
            this.checkUnconsumed(arguments);
            for (InvokeHandler handler : handlers) {
                handler.preInvoke(this.object, this.method, this.parameters, args, context);
            }
            Object result = this.method.invoke(this.object, args);
            for (InvokeHandler handler : handlers) {
                handler.postInvoke(handler, this.method, this.parameters, args, context);
            }
            return result;
        }
        catch (MissingParameterException e) {
            throw new InvalidUsageException("Too few parameters!", this, true);
        }
        catch (UnconsumedParameterException e) {
            throw new InvalidUsageException("Too many parameters! Unused parameters: " + e.getUnconsumed(), this, true);
        }
        catch (ParameterException e) {
            assert (parameter != null);
            String name = parameter.getName();
            throw new InvalidUsageException("For parameter '" + name + "': " + e.getMessage(), this, true);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CommandException) {
                throw (CommandException)e.getCause();
            }
            throw new WrappedCommandException(e);
        }
        catch (Throwable t) {
            throw new WrappedCommandException(t);
        }
    }

    public Object getObject() {
        return this.object;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public ParameterData[] getParameters() {
        return this.parameters;
    }

    @Override
    public Set<Character> getValueFlags() {
        return this.valueFlags;
    }

    @Override
    public Set<Character> getLegacyFlags() {
        return this.legacyFlags;
    }

    @Override
    public SimpleDescription getDescription() {
        return this.description;
    }

    @Override
    public String[] getPermissions() {
        return this.commandPermissions != null ? this.commandPermissions.value() : new String[]{};
    }

    @Override
    public ParametricBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public boolean anyFlags() {
        return this.anyFlags;
    }

    @Override
    public String toString() {
        return this.method.toGenericString();
    }

    public static String generateName(Type type, Annotation classifier, int index) {
        if (classifier != null) {
            return classifier.annotationType().getSimpleName().toLowerCase();
        }
        if (type instanceof Class) {
            return ((Class)type).getSimpleName().toLowerCase();
        }
        return "unknown" + index;
    }
}

