/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.command.parametric;

import com.boydti.fawe.util.StringMan;
import com.google.common.primitives.Chars;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.minecraft.util.commands.WrappedCommandException;
import com.sk89q.worldedit.util.command.CommandCallable;
import com.sk89q.worldedit.util.command.InvalidUsageException;
import com.sk89q.worldedit.util.command.MissingParameterException;
import com.sk89q.worldedit.util.command.Parameter;
import com.sk89q.worldedit.util.command.SimpleDescription;
import com.sk89q.worldedit.util.command.SimpleParameter;
import com.sk89q.worldedit.util.command.UnconsumedParameterException;
import com.sk89q.worldedit.util.command.parametric.AParametricCallable;
import com.sk89q.worldedit.util.command.parametric.ArgumentStack;
import com.sk89q.worldedit.util.command.parametric.Binding;
import com.sk89q.worldedit.util.command.parametric.BindingBehavior;
import com.sk89q.worldedit.util.command.parametric.ContextArgumentStack;
import com.sk89q.worldedit.util.command.parametric.ParameterData;
import com.sk89q.worldedit.util.command.parametric.ParameterException;
import com.sk89q.worldedit.util.command.parametric.ParametricBuilder;
import com.sk89q.worldedit.util.command.parametric.ParametricException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class FunctionParametricCallable
extends AParametricCallable {
    private final ParametricBuilder builder;
    private final ParameterData[] parameters;
    private final Set<Character> valueFlags = new HashSet<Character>();
    private final boolean anyFlags;
    private final Set<Character> legacyFlags = new HashSet<Character>();
    private final SimpleDescription description = new SimpleDescription();
    private final String permission;
    private final Command command;
    private final Function<Object[], ?> function;
    private final String group;

    public FunctionParametricCallable(ParametricBuilder builder, String group, Command command, String permission, List<String> arguments, Function<Object[], ?> function) {
        this.command = command;
        this.permission = permission;
        this.builder = builder;
        this.function = function;
        this.group = group;
        ArrayList<Object[]> paramParsables = new ArrayList<Object[]>();
        Map<Type, Binding> bindings = builder.getBindings();
        HashMap<String, Object> unqualified = new HashMap<String, Object>();
        for (Map.Entry<Type, Binding> entry : bindings.entrySet()) {
            Type type = entry.getKey();
            String typeStr = type.getTypeName();
            unqualified.put(typeStr, type);
            unqualified.put(typeStr.substring(typeStr.lastIndexOf(46) + 1), type);
        }
        Object[] param = null;
        boolean checkEq = false;
        int checkEqI = 0;
        for (int i = 0; i < arguments.size(); ++i) {
            String arg = arguments.get(i);
            if (arg.equals("=")) {
                ++checkEqI;
                checkEq = true;
                continue;
            }
            if (param == null || !checkEq) {
                if (param != null) {
                    paramParsables.add(param);
                }
                param = new Object[]{arg, arg.length() == 1 && command.flags().contains(arg) ? Boolean.class : String.class, null};
                checkEqI = 0;
                checkEq = false;
                continue;
            }
            if (checkEqI == 1) {
                param[1] = unqualified.getOrDefault(arg, String.class);
                checkEq = false;
                continue;
            }
            if (checkEqI != 2) continue;
            char c = arg.charAt(0);
            if (c == '\'' || c == '\"') {
                arg = arg.substring(1, arg.length() - 1);
            }
            param[2] = arg;
            checkEqI = 0;
            checkEq = false;
        }
        if (param != null) {
            paramParsables.add(param);
        }
        this.parameters = new ParameterData[paramParsables.size()];
        ArrayList<Parameter> userParameters = new ArrayList<Parameter>();
        int numOptional = 0;
        for (int i = 0; i < paramParsables.size(); ++i) {
            boolean flag;
            Object[] parsable = (Object[])paramParsables.get(i);
            String paramName = (String)parsable[0];
            Type type = (Type)parsable[1];
            String optional = (String)parsable[2];
            ParameterData parameter = new ParameterData();
            parameter.setType(type);
            parameter.setModifiers(new Annotation[0]);
            boolean bl = flag = paramName.length() == 1 && command.flags().contains(paramName);
            if (flag) {
                parameter.setFlag(Character.valueOf(paramName.charAt(0)), type != Boolean.TYPE && type != Boolean.class);
            }
            if (optional != null) {
                parameter.setOptional(true);
                if (!optional.equalsIgnoreCase("null")) {
                    parameter.setDefaultValue(new String[]{optional});
                }
            }
            parameter.setName(paramName);
            if (parameter.isValueFlag()) {
                this.valueFlags.add(parameter.getFlag());
            }
            if (parameter.getBinding() == null) {
                parameter.setBinding(builder.getBindings().get(type));
                if (parameter.getBinding() == null) {
                    throw new ParametricException("Don't know how to handle the parameter type '" + type + "' in\n" + StringMan.getString(command.aliases()));
                }
            }
            parameter.validate(() -> StringMan.getString(command.aliases()), i + 1);
            if (parameter.isOptional() && parameter.getFlag() == null) {
                ++numOptional;
            } else if (numOptional > 0 && parameter.isNonFlagConsumer() && parameter.getConsumedCount() < 0) {
                throw new ParametricException("Found an parameter using the binding " + parameter.getBinding().getClass().getCanonicalName() + "\nthat does not know how many arguments it consumes, but " + "it follows an optional parameter\nMethod: " + StringMan.getString(command.aliases()));
            }
            this.parameters[i] = parameter;
            if (!parameter.isUserInput()) continue;
            userParameters.add(parameter);
        }
        this.anyFlags = command.anyFlags();
        this.legacyFlags.addAll(Chars.asList((char[])command.flags().toCharArray()));
        this.description.setDescription(!command.desc().isEmpty() ? command.desc() : null);
        this.description.setHelp(!command.help().isEmpty() ? command.help() : null);
        this.description.overrideUsage(!command.usage().isEmpty() ? command.usage() : null);
        this.description.setPermissions(Arrays.asList(permission));
        if (command.usage().isEmpty() && (command.min() > 0 || command.max() > 0)) {
            boolean hasUserParameters = false;
            for (ParameterData parameter : this.parameters) {
                if (parameter.getBinding().getBehavior(parameter) == BindingBehavior.PROVIDES) continue;
                hasUserParameters = true;
                break;
            }
            if (!hasUserParameters) {
                this.description.overrideUsage("(unknown usage information)");
            }
        }
        this.description.setParameters(userParameters);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public Command getCommand() {
        return this.command;
    }

    @Override
    public ParameterData[] getParameters() {
        return this.parameters;
    }

    @Override
    public Set<Character> getValueFlags() {
        return this.valueFlags;
    }

    @Override
    public Set<Character> getLegacyFlags() {
        return this.legacyFlags;
    }

    @Override
    public Object call(String stringArguments, CommandLocals locals, String[] parentCommands) throws CommandException {
        if (!this.testPermission(locals)) {
            throw new CommandPermissionsException();
        }
        locals.putIfAbsent(CommandCallable.class, this);
        String calledCommand = parentCommands.length > 0 ? parentCommands[parentCommands.length - 1] : "_";
        String[] split = (calledCommand + " " + stringArguments).split(" ", -1);
        CommandContext context = new CommandContext(split, this.getValueFlags(), false, locals);
        if (context.hasFlag('?')) {
            throw new InvalidUsageException(null, this, true);
        }
        Object[] args = new Object[this.parameters.length];
        ContextArgumentStack arguments = new ContextArgumentStack(context);
        SimpleParameter parameter = null;
        try {
            for (int i = 0; i < this.parameters.length; ++i) {
                parameter = this.parameters[i];
                if (this.mayConsumeArguments(i, arguments)) {
                    ArgumentStack usedArguments = FunctionParametricCallable.getScopedContext(parameter, arguments);
                    try {
                        usedArguments.mark();
                        args[i] = ((ParameterData)parameter).getBinding().bind((ParameterData)parameter, usedArguments, false);
                    }
                    catch (ParameterException e) {
                        if (!parameter.isOptional()) {
                            throw e;
                        }
                        usedArguments.reset();
                        args[i] = this.getDefaultValue(i, arguments);
                    }
                    continue;
                }
                args[i] = this.getDefaultValue(i, arguments);
            }
            this.checkUnconsumed(arguments);
            if (context.argsLength() < this.command.min()) {
                throw new MissingParameterException();
            }
            if (this.command.max() != -1 && context.argsLength() > this.command.max()) {
                throw new UnconsumedParameterException(context.getRemainingString(this.command.max()));
            }
            Object result = this.function.apply(args);
            return result;
        }
        catch (MissingParameterException e) {
            throw new InvalidUsageException("Too few parameters!", this, true);
        }
        catch (UnconsumedParameterException e) {
            throw new InvalidUsageException("Too many parameters! Unused parameters: " + e.getUnconsumed(), this, true);
        }
        catch (ParameterException e) {
            assert (parameter != null);
            String name = parameter.getName();
            throw new InvalidUsageException("For parameter '" + name + "': " + e.getMessage(), this, true);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CommandException) {
                throw (CommandException)e.getCause();
            }
            throw new WrappedCommandException(e);
        }
        catch (Throwable t) {
            throw new WrappedCommandException(t);
        }
    }

    @Override
    public boolean testPermission(CommandLocals locals) {
        return this.permission != null ? this.builder.getAuthorizer().testPermission(locals, this.permission) : true;
    }

    @Override
    public SimpleDescription getDescription() {
        return this.description;
    }

    @Override
    public String[] getPermissions() {
        return new String[]{this.permission};
    }

    @Override
    public ParametricBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public boolean anyFlags() {
        return this.anyFlags;
    }

    @Override
    public String toString() {
        return this.command.aliases()[0];
    }
}

