/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.util.Direction;

public class Location
extends Vector {
    private final Extent extent;
    private final float pitch;
    private final float yaw;

    public Location(Extent extent) {
        this(extent, new Vector(), new Vector());
    }

    public Location(Extent extent, double x, double y, double z) {
        this(extent, new Vector(x, y, z), new Vector());
    }

    public Location(Extent extent, Vector position) {
        this(extent, position, new Vector());
    }

    public Location(Extent extent, double x, double y, double z, Vector direction) {
        this(extent, new Vector(x, y, z), direction);
    }

    public Location(Extent extent, double x, double y, double z, float yaw, float pitch) {
        this(extent, new Vector(x, y, z), yaw, pitch);
    }

    public Location(Extent extent, Vector position, Vector direction) {
        this(extent, position, direction.toYaw(), direction.toPitch());
    }

    public Location(Extent extent, Vector position, float yaw, float pitch) {
        super(position);
        Preconditions.checkNotNull((Object)extent);
        this.extent = extent;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public Extent getExtent() {
        return this.extent;
    }

    public Location setExtent(Extent extent) {
        return new Location(extent, this, this.getDirection());
    }

    public float getYaw() {
        return this.yaw;
    }

    public Location setYaw(float yaw) {
        return new Location(this.extent, this, yaw, this.pitch);
    }

    public float getPitch() {
        return this.pitch;
    }

    public Location setPitch(float pitch) {
        return new Location(this.extent, this, this.yaw, pitch);
    }

    public Location setDirection(float yaw, float pitch) {
        return new Location(this.extent, this, yaw, pitch);
    }

    public Vector getDirection() {
        double yaw = Math.toRadians(this.getYaw());
        double pitch = Math.toRadians(this.getPitch());
        double xz = Math.cos(pitch);
        return new Vector(-xz * Math.sin(yaw), -Math.sin(pitch), xz * Math.cos(yaw));
    }

    public Direction getDirectionEnum() {
        return Direction.findClosest(this.getDirection(), Direction.Flag.ALL);
    }

    public Location setDirection(Vector direction) {
        return new Location(this.extent, this, direction.toYaw(), direction.toPitch());
    }

    @Override
    public Vector toVector() {
        return this;
    }

    @Override
    public Location setX(double x) {
        return new Location(this.extent, super.setX(x), this.yaw, this.pitch);
    }

    @Override
    public Location setX(int x) {
        return new Location(this.extent, super.setX(x), this.yaw, this.pitch);
    }

    @Override
    public Location setY(double y) {
        return new Location(this.extent, super.setY(y), this.yaw, this.pitch);
    }

    @Override
    public Location setY(int y) {
        return new Location(this.extent, super.setY(y), this.yaw, this.pitch);
    }

    @Override
    public Location setZ(double z) {
        return new Location(this.extent, super.setZ(z), this.yaw, this.pitch);
    }

    @Override
    public Location setZ(int z) {
        return new Location(this.extent, super.setZ(z), this.yaw, this.pitch);
    }

    public Location setPosition(Vector position) {
        return new Location(this.extent, position, this.yaw, this.pitch);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        if (Double.doubleToLongBits(this.pitch) != Double.doubleToLongBits(location.pitch)) {
            return false;
        }
        if (Double.doubleToLongBits(this.yaw) != Double.doubleToLongBits(location.yaw)) {
            return false;
        }
        if (this.getX() != location.getX()) {
            return false;
        }
        if (this.getZ() != location.getZ()) {
            return false;
        }
        if (this.getY() != location.getY()) {
            return false;
        }
        return this.extent.equals(location.extent);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

