/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.scripting;

import com.boydti.fawe.Fawe;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.scripting.CraftScriptEngine;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;

public class NashornCraftScriptEngine
implements CraftScriptEngine {
    private static NashornScriptEngineFactory FACTORY;
    private int timeLimit;

    @Override
    public void setTimeLimit(int milliseconds) {
        this.timeLimit = milliseconds;
    }

    @Override
    public int getTimeLimit() {
        return this.timeLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object evaluate(String script, String filename, Map<String, Object> args) throws Throwable {
        ClassLoader cl = Fawe.get().getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        Class<NashornCraftScriptEngine> clazz = NashornCraftScriptEngine.class;
        synchronized (NashornCraftScriptEngine.class) {
            if (FACTORY == null) {
                FACTORY = new NashornScriptEngineFactory();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            ScriptEngine engine = FACTORY.getScriptEngine(new String[]{"--language=es6"});
            SimpleBindings bindings = new SimpleBindings();
            for (Map.Entry<String, Object> entry : args.entrySet()) {
                bindings.put(entry.getKey(), entry.getValue());
            }
            try {
                Object result = engine.eval(script, (Bindings)bindings);
                return result;
            }
            catch (Error e) {
                e.printStackTrace();
                throw new ScriptException(e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                while (e.getCause() != null) {
                    e = e.getCause();
                }
                if (!(e instanceof WorldEditException)) throw e;
                throw e;
            }
        }
    }
}

