/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.registry;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.registry.Registry;
import java.util.Objects;
import javax.annotation.Nullable;

public final class NamespacedRegistry<V>
extends Registry<V> {
    private static final String MINECRAFT_NAMESPACE = "minecraft";
    private final String defaultNamespace;

    public NamespacedRegistry(String name) {
        this(name, MINECRAFT_NAMESPACE);
    }

    public NamespacedRegistry(String name, String defaultNamespace) {
        super(name);
        this.defaultNamespace = defaultNamespace;
    }

    @Override
    @Nullable
    public V get(String key) {
        return super.get(this.orDefaultNamespace(key));
    }

    @Override
    public V register(String key, V value) {
        Objects.requireNonNull(key, "key");
        Preconditions.checkState((key.indexOf(58) > -1 ? 1 : 0) != 0, (Object)"key is not namespaced");
        return super.register(key, value);
    }

    private String orDefaultNamespace(String key) {
        if (key.indexOf(58) == -1) {
            return this.defaultNamespace + ':' + key;
        }
        return key;
    }
}

