/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.visitor;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.example.MappedFaweQueue;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.object.IntegerTrio;
import com.boydti.fawe.object.collection.BlockVectorSet;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class BreadthFirstSearch
implements Operation {
    public static final Vector[] DEFAULT_DIRECTIONS = new Vector[6];
    public static final Vector[] DIAGONAL_DIRECTIONS;
    private final RegionFunction function;
    private List<Vector> directions = new ArrayList<Vector>();
    private BlockVectorSet visited;
    private final MappedFaweQueue mFaweQueue;
    private BlockVectorSet queue;
    private int currentDepth = 0;
    private final int maxDepth;
    private int affected = 0;
    private int maxBranch = Integer.MAX_VALUE;

    public BreadthFirstSearch(RegionFunction function) {
        this(function, Integer.MAX_VALUE);
    }

    public BreadthFirstSearch(RegionFunction function, int maxDepth) {
        this(function, maxDepth, null);
    }

    public BreadthFirstSearch(RegionFunction function, int maxDepth, HasFaweQueue faweQueue) {
        FaweQueue fq = faweQueue != null ? faweQueue.getQueue() : null;
        this.mFaweQueue = fq instanceof MappedFaweQueue ? (MappedFaweQueue)fq : null;
        this.queue = new BlockVectorSet();
        this.visited = new BlockVectorSet();
        this.function = function;
        this.directions.addAll(Arrays.asList(DEFAULT_DIRECTIONS));
        this.maxDepth = maxDepth;
    }

    public abstract boolean isVisitable(Vector var1, Vector var2);

    public Collection<Vector> getDirections() {
        return this.directions;
    }

    public void setDirections(List<Vector> directions) {
        this.directions = directions;
    }

    private IntegerTrio[] getIntDirections() {
        IntegerTrio[] array = new IntegerTrio[this.directions.size()];
        for (int i = 0; i < array.length; ++i) {
            Vector dir = this.directions.get(i);
            array[i] = new IntegerTrio(dir.getBlockX(), dir.getBlockY(), dir.getBlockZ());
        }
        return array;
    }

    public void visit(Vector pos) {
        if (!this.isVisited(pos)) {
            this.isVisitable(pos, pos);
            this.queue.add(pos);
            this.visited.add(pos);
        }
    }

    public void resetVisited() {
        this.queue.clear();
        this.visited.clear();
        this.affected = 0;
    }

    public void setVisited(BlockVectorSet set) {
        this.visited = set;
    }

    public BlockVectorSet getVisited() {
        return this.visited;
    }

    public boolean isVisited(Vector pos) {
        return this.visited.contains(pos);
    }

    public void setMaxBranch(int maxBranch) {
        this.maxBranch = maxBranch;
    }

    @Override
    public Operation resume(RunContext run) throws WorldEditException {
        MutableBlockVector mutable = new MutableBlockVector();
        MutableBlockVector mutable2 = new MutableBlockVector();
        boolean shouldTrim = false;
        IntegerTrio[] dirs = this.getIntDirections();
        BlockVectorSet tempQueue = new BlockVectorSet();
        BlockVectorSet chunkLoadSet = new BlockVectorSet();
        this.currentDepth = 0;
        while (!this.queue.isEmpty() && this.currentDepth <= this.maxDepth) {
            if (this.mFaweQueue != null && Settings.IMP.QUEUE.PRELOAD_CHUNKS > 1) {
                int cx = Integer.MIN_VALUE;
                int cz = Integer.MIN_VALUE;
                for (Vector from : this.queue) {
                    for (IntegerTrio direction : dirs) {
                        int y;
                        int x = from.getBlockX() + direction.x;
                        int z = from.getBlockZ() + direction.z;
                        if (cx == (cx = x >> 4) && cz == (cz = z >> 4) || (y = from.getBlockY() + direction.y) < 0 || y >= 256 || this.visited.contains(x, y, z)) continue;
                        chunkLoadSet.add(cx, 0, cz);
                    }
                }
                for (Vector chunk : chunkLoadSet) {
                    this.mFaweQueue.queueChunkLoad(chunk.getBlockX(), chunk.getBlockZ());
                }
            }
            for (Vector from : this.queue) {
                if (this.function.apply(from)) {
                    ++this.affected;
                }
                int j = 0;
                for (int i = 0; i < dirs.length && j < this.maxBranch; ++i) {
                    int z;
                    int x;
                    IntegerTrio direction = dirs[i];
                    int y = from.getBlockY() + direction.y;
                    if (y < 0 || y >= 256 || this.visited.contains(x = from.getBlockX() + direction.x, y, z = from.getBlockZ() + direction.z)) continue;
                    mutable2.mutX(x);
                    mutable2.mutY(y);
                    mutable2.mutZ(z);
                    if (!this.isVisitable(from, mutable2)) continue;
                    ++j;
                    this.visited.add(x, y, z);
                    tempQueue.add(x, y, z);
                }
            }
            if (this.currentDepth == this.maxDepth) break;
            int size = this.queue.size();
            BlockVectorSet tmp = this.queue;
            this.queue = tempQueue;
            tmp.clear();
            chunkLoadSet.clear();
            tempQueue = tmp;
            ++this.currentDepth;
        }
        return null;
    }

    public int getDepth() {
        return this.currentDepth;
    }

    @Override
    public void addStatusMessages(List<String> messages) {
        messages.add(BBC.VISITOR_BLOCK.format(this.getAffected()));
    }

    public int getAffected() {
        return this.affected;
    }

    @Override
    public void cancel() {
    }

    static {
        BreadthFirstSearch.DEFAULT_DIRECTIONS[0] = new MutableBlockVector(0, -1, 0);
        BreadthFirstSearch.DEFAULT_DIRECTIONS[1] = new MutableBlockVector(0, 1, 0);
        BreadthFirstSearch.DEFAULT_DIRECTIONS[2] = new MutableBlockVector(-1, 0, 0);
        BreadthFirstSearch.DEFAULT_DIRECTIONS[3] = new MutableBlockVector(1, 0, 0);
        BreadthFirstSearch.DEFAULT_DIRECTIONS[4] = new MutableBlockVector(0, 0, -1);
        BreadthFirstSearch.DEFAULT_DIRECTIONS[5] = new MutableBlockVector(0, 0, 1);
        ArrayList<MutableBlockVector> list = new ArrayList<MutableBlockVector>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    MutableBlockVector pos;
                    if (x == 0 && y == 0 && z == 0 || list.contains(pos = new MutableBlockVector(x, y, z))) continue;
                    list.add(pos);
                }
            }
        }
        Collections.sort(list, new Comparator<Vector>(){

            @Override
            public int compare(Vector o1, Vector o2) {
                return (int)Math.signum(o1.lengthSq() - o2.lengthSq());
            }
        });
        DIAGONAL_DIRECTIONS = list.toArray(new Vector[list.size()]);
    }
}

