/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.mask;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.BlockMaskBuilder;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;

public class SingleBlockTypeMask
extends AbstractExtentMask {
    private final int internalId;

    public SingleBlockTypeMask(Extent extent, BlockType type) {
        super(extent);
        this.internalId = type.getInternalId();
    }

    @Override
    public boolean test(Vector vector) {
        return this.getExtent().getBlockType(vector).getInternalId() == this.internalId;
    }

    @Override
    public Mask inverse() {
        return new BlockMaskBuilder().add(BlockTypes.get(this.internalId)).build(this.getExtent()).inverse();
    }

    public BlockType getBlockType() {
        return BlockTypes.get(this.internalId);
    }
}

