/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.jnbt.CorruptSchematicStreamer;
import com.boydti.fawe.jnbt.SchematicStreamer;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class SchematicReader
implements ClipboardReader {
    private static final Logger log = Logger.getLogger(SchematicReader.class.getCanonicalName());
    private NBTInputStream inputStream;
    private InputStream rootStream;

    public SchematicReader(NBTInputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        this.inputStream = inputStream;
    }

    public void setUnderlyingStream(InputStream in) {
        this.rootStream = in;
    }

    @Override
    public Clipboard read() throws IOException {
        return this.read(UUID.randomUUID());
    }

    @Override
    public Clipboard read(UUID clipboardId) throws IOException {
        try {
            return new SchematicStreamer(this.inputStream, clipboardId).getClipboard();
        }
        catch (Exception e) {
            Fawe.debug("Input is corrupt!");
            e.printStackTrace();
            return new CorruptSchematicStreamer(this.rootStream, clipboardId).recover();
        }
    }

    private static <T extends Tag> T requireTag(Map<String, Tag> items, String key, Class<T> expected) throws IOException {
        if (!items.containsKey(key)) {
            throw new IOException("Schematic file is missing a \"" + key + "\" tag");
        }
        Tag tag = items.get(key);
        if (!expected.isInstance(tag)) {
            throw new IOException(key + " tag is not of tag type " + expected.getName());
        }
        return (T)((Tag)expected.cast(tag));
    }

    @Nullable
    private static <T extends Tag> T getTag(CompoundTag tag, Class<T> expected, String key) {
        Object items = tag.getValue();
        if (!items.containsKey(key)) {
            return null;
        }
        Tag test = (Tag)items.get(key);
        if (!expected.isInstance(test)) {
            return null;
        }
        return (T)((Tag)expected.cast(test));
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

