/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.platform;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.command.AnvilCommands;
import com.boydti.fawe.command.CFICommand;
import com.boydti.fawe.command.MaskBinding;
import com.boydti.fawe.command.PatternBinding;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.task.ThrowableSupplier;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.wrappers.FakePlayer;
import com.boydti.fawe.wrappers.LocationMaskedPlayerWrapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.BiomeCommands;
import com.sk89q.worldedit.command.BrushCommands;
import com.sk89q.worldedit.command.BrushOptionsCommands;
import com.sk89q.worldedit.command.ChunkCommands;
import com.sk89q.worldedit.command.ClipboardCommands;
import com.sk89q.worldedit.command.GenerationCommands;
import com.sk89q.worldedit.command.HistoryCommands;
import com.sk89q.worldedit.command.NavigationCommands;
import com.sk89q.worldedit.command.OptionsCommands;
import com.sk89q.worldedit.command.RegionCommands;
import com.sk89q.worldedit.command.SchematicCommands;
import com.sk89q.worldedit.command.ScriptingCommands;
import com.sk89q.worldedit.command.SelectionCommands;
import com.sk89q.worldedit.command.SnapshotCommands;
import com.sk89q.worldedit.command.SnapshotUtilCommands;
import com.sk89q.worldedit.command.SuperPickaxeCommands;
import com.sk89q.worldedit.command.ToolCommands;
import com.sk89q.worldedit.command.UtilityCommands;
import com.sk89q.worldedit.command.WorldEditCommands;
import com.sk89q.worldedit.command.argument.ReplaceParser;
import com.sk89q.worldedit.command.argument.TreeGeneratorParser;
import com.sk89q.worldedit.command.composition.ApplyCommand;
import com.sk89q.worldedit.command.composition.DeformCommand;
import com.sk89q.worldedit.command.composition.PaintCommand;
import com.sk89q.worldedit.command.composition.ShapedBrushCommand;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.CommandSuggestionEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extension.platform.PlatformManager;
import com.sk89q.worldedit.function.factory.Deform;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.command.ActorAuthorizer;
import com.sk89q.worldedit.internal.command.CommandLoggingHandler;
import com.sk89q.worldedit.internal.command.UserCommandCompleter;
import com.sk89q.worldedit.internal.command.WorldEditBinding;
import com.sk89q.worldedit.internal.command.WorldEditExceptionConverter;
import com.sk89q.worldedit.scripting.CommandScriptLoader;
import com.sk89q.worldedit.session.request.Request;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.command.CallableProcessor;
import com.sk89q.worldedit.util.command.CommandCallable;
import com.sk89q.worldedit.util.command.CommandMapping;
import com.sk89q.worldedit.util.command.Dispatcher;
import com.sk89q.worldedit.util.command.composition.LegacyCommandAdapter;
import com.sk89q.worldedit.util.command.composition.ProvidedValue;
import com.sk89q.worldedit.util.command.fluent.CommandGraph;
import com.sk89q.worldedit.util.command.fluent.DispatcherNode;
import com.sk89q.worldedit.util.command.parametric.AParametricCallable;
import com.sk89q.worldedit.util.command.parametric.ExceptionConverter;
import com.sk89q.worldedit.util.command.parametric.LegacyCommandsHandler;
import com.sk89q.worldedit.util.command.parametric.ParametricBuilder;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.util.logging.DynamicStreamHandler;
import com.sk89q.worldedit.util.logging.LogFormat;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class CommandManager {
    public static final java.util.regex.Pattern COMMAND_CLEAN_PATTERN = java.util.regex.Pattern.compile("^[/]+");
    private static final Logger log = Logger.getLogger(CommandManager.class.getCanonicalName());
    private static final Logger commandLog = Logger.getLogger(CommandManager.class.getCanonicalName() + ".CommandLog");
    private static final java.util.regex.Pattern numberFormatExceptionPattern = java.util.regex.Pattern.compile("^For input string: \"(.*)\"$");
    private final WorldEdit worldEdit;
    private final PlatformManager platformManager;
    private volatile Dispatcher dispatcher;
    private volatile Platform platform;
    private final DynamicStreamHandler dynamicHandler = new DynamicStreamHandler();
    private final ExceptionConverter exceptionConverter;
    private ParametricBuilder builder;
    private Map<Object, String[]> methodMap;
    private Map<CommandCallable, String[][]> commandMap;
    private static CommandManager INSTANCE;

    public CommandManager(WorldEdit worldEdit, PlatformManager platformManager) {
        Preconditions.checkNotNull((Object)worldEdit);
        Preconditions.checkNotNull((Object)platformManager);
        INSTANCE = this;
        this.worldEdit = worldEdit;
        this.platformManager = platformManager;
        this.exceptionConverter = new WorldEditExceptionConverter(worldEdit);
        worldEdit.getEventBus().register(this);
        commandLog.addHandler(this.dynamicHandler);
        this.dynamicHandler.setFormatter(new LogFormat());
        this.builder = new ParametricBuilder();
        this.builder.setAuthorizer(new ActorAuthorizer());
        this.builder.setDefaultCompleter(new UserCommandCompleter(platformManager));
        this.builder.addBinding(new WorldEditBinding(worldEdit), new Type[0]);
        this.builder.addBinding(new PatternBinding(worldEdit), new Type[]{Pattern.class});
        this.builder.addBinding(new MaskBinding(worldEdit), new Type[]{Mask.class});
        this.builder.addInvokeListener(new LegacyCommandsHandler());
        this.builder.addInvokeListener(new CommandLoggingHandler(worldEdit, commandLog));
        this.methodMap = new ConcurrentHashMap<Object, String[]>();
        this.commandMap = new ConcurrentHashMap<CommandCallable, String[][]>();
        try {
            Class.forName("com.intellectualcrafters.plot.PS");
            CFICommand cfi = new CFICommand(worldEdit, this.builder);
            this.registerCommands(cfi);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void registerCommands(Object clazz) {
        this.registerCommands(clazz, new String[0]);
    }

    public void registerCommands(Object clazz, String ... aliases) {
        if (this.platform != null) {
            if (aliases.length == 0) {
                this.builder.registerMethodsAsCommands(this.dispatcher, clazz);
            } else {
                DispatcherNode graph = new CommandGraph().builder(this.builder).commands();
                graph = graph.registerMethods(clazz);
                this.dispatcher.registerCommand(graph.graph().getDispatcher(), aliases);
            }
            this.platform.registerCommands(this.dispatcher);
        } else {
            this.methodMap.put(clazz, aliases);
        }
    }

    public void registerCommands(Object clazz, CallableProcessor processor, String ... aliases) {
        if (this.platform != null) {
            if (aliases.length == 0) {
                this.builder.registerMethodsAsCommands(this.dispatcher, clazz, processor);
            } else {
                DispatcherNode graph = new CommandGraph().builder(this.builder).commands();
                graph = graph.registerMethods(clazz, processor);
                this.dispatcher.registerCommand(graph.graph().getDispatcher(), aliases);
            }
            this.platform.registerCommands(this.dispatcher);
        } else {
            this.methodMap.put(clazz, aliases);
        }
    }

    public void registerCommand(String[] aliases, Command command, CommandCallable callable) {
        if (this.platform != null) {
            if (aliases.length == 0) {
                this.dispatcher.registerCommand(callable, command.aliases());
            } else {
                DispatcherNode graph = new CommandGraph().builder(this.builder).commands();
                graph = graph.register(callable, command.aliases());
                this.dispatcher.registerCommand(graph.graph().getDispatcher(), aliases);
            }
            this.platform.registerCommands(this.dispatcher);
        } else {
            this.commandMap.putIfAbsent(callable, new String[][]{aliases, command.aliases()});
        }
    }

    public ParametricBuilder getBuilder() {
        return this.builder;
    }

    public void setupDispatcher() {
        String[] aliases;
        DispatcherNode graph = new CommandGraph().builder(this.builder).commands();
        for (Map.Entry<Object, String[]> entry : this.methodMap.entrySet()) {
            aliases = entry.getValue();
            if (aliases.length == 0) {
                graph = graph.registerMethods(entry.getKey());
                continue;
            }
            graph = graph.group(aliases).registerMethods(entry.getKey()).parent();
        }
        for (Map.Entry<Object, String[]> entry : this.commandMap.entrySet()) {
            aliases = (String[][])entry.getValue();
            CommandCallable callable = (CommandCallable)entry.getKey();
            if (((String)aliases[0]).length == 0) {
                graph = graph.register(callable, (String[])aliases[1]);
                continue;
            }
            graph = graph.group((String[])aliases[0]).register(callable, (String[])aliases[1]).parent();
        }
        this.commandMap.clear();
        this.methodMap.clear();
        this.dispatcher = graph.group("/anvil").describeAs("Anvil command").registerMethods(new AnvilCommands(this.worldEdit)).parent().registerMethods(new BiomeCommands(this.worldEdit)).registerMethods(new ChunkCommands(this.worldEdit)).registerMethods(new ClipboardCommands(this.worldEdit)).registerMethods(new OptionsCommands(this.worldEdit)).registerMethods(new GenerationCommands(this.worldEdit)).registerMethods(new HistoryCommands(this.worldEdit)).registerMethods(new NavigationCommands(this.worldEdit)).registerMethods(new RegionCommands(this.worldEdit)).registerMethods(new ScriptingCommands(this.worldEdit)).registerMethods(new SelectionCommands(this.worldEdit)).registerMethods(new SnapshotUtilCommands(this.worldEdit)).registerMethods(new BrushOptionsCommands(this.worldEdit)).registerMethods(new ToolCommands(this.worldEdit)).registerMethods(new UtilityCommands(this.worldEdit)).registerSubMethods(new WorldEditCommands(this.worldEdit)).registerSubMethods(new SchematicCommands(this.worldEdit)).registerSubMethods(new SnapshotCommands(this.worldEdit)).groupAndDescribe(BrushCommands.class).registerMethods(new BrushCommands(this.worldEdit)).registerMethods(new ToolCommands(this.worldEdit)).registerMethods(new BrushOptionsCommands(this.worldEdit)).register(LegacyCommandAdapter.adapt(new ShapedBrushCommand(new DeformCommand(), "worldedit.brush.deform")), "deform").register(LegacyCommandAdapter.adapt(new ShapedBrushCommand(new ApplyCommand(new ReplaceParser(), "Set all blocks within region"), "worldedit.brush.set")), "set").register(LegacyCommandAdapter.adapt(new ShapedBrushCommand(new PaintCommand(), "worldedit.brush.paint")), "paint").register(LegacyCommandAdapter.adapt(new ShapedBrushCommand(new ApplyCommand(), "worldedit.brush.apply")), "apply").register(LegacyCommandAdapter.adapt(new ShapedBrushCommand(new PaintCommand(new TreeGeneratorParser("treeType")), "worldedit.brush.forest")), "forest").register(LegacyCommandAdapter.adapt(new ShapedBrushCommand(ProvidedValue.create(new Deform("y-=1", Deform.Mode.RAW_COORD), "Raise one block"), "worldedit.brush.raise")), "raise").register(LegacyCommandAdapter.adapt(new ShapedBrushCommand(ProvidedValue.create(new Deform("y+=1", Deform.Mode.RAW_COORD), "Lower one block"), "worldedit.brush.lower")), "lower").parent().group("superpickaxe", "pickaxe", "sp").describeAs("Super-pickaxe commands").registerMethods(new SuperPickaxeCommands(this.worldEdit)).parent().graph().getDispatcher();
        if (this.platform != null) {
            this.platform.registerCommands(this.dispatcher);
        }
    }

    public static CommandManager getInstance() {
        return INSTANCE;
    }

    public ExceptionConverter getExceptionConverter() {
        return this.exceptionConverter;
    }

    public void register(Platform platform) {
        log.log(Level.FINE, "Registering commands with " + platform.getClass().getCanonicalName());
        this.platform = null;
        try {
            new CommandScriptLoader().load();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        LocalConfiguration config = platform.getConfiguration();
        boolean logging = config.logCommands;
        String path = config.logFile;
        if (!logging || path.isEmpty()) {
            this.dynamicHandler.setHandler(null);
            commandLog.setLevel(Level.OFF);
        } else {
            File file = new File(config.getWorkingDirectory(), path);
            commandLog.setLevel(Level.ALL);
            log.log(Level.INFO, "Logging WorldEdit commands to " + file.getAbsolutePath());
            try {
                this.dynamicHandler.setHandler(new FileHandler(file.getAbsolutePath(), true));
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Could not use command log file " + path + ": " + e.getMessage());
            }
        }
        this.platform = platform;
        this.setupDispatcher();
    }

    public void unregister() {
        this.dynamicHandler.setHandler(null);
    }

    public String[] commandDetection(String[] split) {
        String searchCmd;
        if (split[0].matches("^[^/].*\\.js$")) {
            String[] newSplit = new String[split.length + 1];
            System.arraycopy(split, 0, newSplit, 1, split.length);
            newSplit[0] = "cs";
            newSplit[1] = newSplit[1];
            split = newSplit;
        }
        if (!this.dispatcher.contains(searchCmd = split[0].toLowerCase())) {
            if (this.worldEdit.getConfiguration().noDoubleSlash && this.dispatcher.contains("/" + searchCmd)) {
                split[0] = "/" + split[0];
            } else if (searchCmd.length() >= 2 && searchCmd.charAt(0) == '/' && this.dispatcher.contains(searchCmd.substring(1))) {
                split[0] = split[0].substring(1);
            }
        }
        return split;
    }

    public void handleCommandOnCurrentThread(CommandEvent event) {
        Actor actor = this.platformManager.createProxyActor(event.getActor());
        String args = event.getArguments();
        final String[] split = this.commandDetection(args.split(" "));
        if (!this.dispatcher.contains(split[0])) {
            return;
        }
        if (!actor.isPlayer()) {
            actor = FakePlayer.wrap(actor.getName(), actor.getUniqueId(), actor);
        }
        LocalSession session = this.worldEdit.getSessionManager().get(actor);
        LocalConfiguration config = this.worldEdit.getConfiguration();
        final CommandLocals locals = new CommandLocals();
        FawePlayer fp = FawePlayer.wrap(actor);
        if (fp == null) {
            throw new IllegalArgumentException("FAWE doesn't support: " + actor);
        }
        final LinkedHashSet<String> failedPermissions = new LinkedHashSet<String>();
        locals.put("failed_permissions", failedPermissions);
        locals.put(LocalSession.class, session);
        if (actor instanceof Player) {
            Player player = (Player)actor;
            Player unwrapped = LocationMaskedPlayerWrapper.unwrap(player);
            actor = new LocationMaskedPlayerWrapper(unwrapped, player.getLocation(), true){

                @Override
                public boolean hasPermission(String permission) {
                    if (!super.hasPermission(permission)) {
                        failedPermissions.add(permission);
                        return false;
                    }
                    return true;
                }

                @Override
                public void checkPermission(String permission) throws AuthorizationException {
                    try {
                        super.checkPermission(permission);
                    }
                    catch (AuthorizationException e) {
                        failedPermissions.add(permission);
                        throw e;
                    }
                }
            };
        }
        locals.put(Actor.class, actor);
        Actor finalActor = actor;
        locals.put("arguments", args);
        ThrowableSupplier<Throwable> task = new ThrowableSupplier<Throwable>(){

            @Override
            public Object get() throws Throwable {
                return CommandManager.this.dispatcher.call(Joiner.on((String)" ").join((Object[])split), locals, new String[0]);
            }
        };
        this.handleCommandTask(task, locals, actor, session, failedPermissions, fp);
    }

    public Object handleCommandTask(ThrowableSupplier<Throwable> task, CommandLocals locals) {
        return this.handleCommandTask(task, locals, null, null, null, null);
    }

    /*
     * Exception decompiling
     */
    private Object handleCommandTask(ThrowableSupplier<Throwable> task, CommandLocals locals, @Nullable Actor actor, @Nullable LocalSession session, @Nullable Set<String> failedPermissions, @Nullable FawePlayer fp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Subscribe
    public void handleCommand(CommandEvent event) {
        Request.reset();
        Actor actor = event.getActor();
        if (actor instanceof Player) {
            actor = LocationMaskedPlayerWrapper.wrap((Player)actor);
        }
        final String args = event.getArguments();
        final CommandEvent finalEvent = new CommandEvent(actor, args);
        final FawePlayer fp = FawePlayer.wrap(actor);
        TaskManager.IMP.taskNow(new Runnable(){

            @Override
            public void run() {
                Command info;
                int space0 = args.indexOf(32);
                String arg0 = space0 == -1 ? args : args.substring(0, space0);
                CommandMapping cmd = CommandManager.this.dispatcher.get(arg0);
                if (cmd != null && cmd.getCallable() instanceof AParametricCallable && !(info = ((AParametricCallable)cmd.getCallable()).getDefinition()).queued()) {
                    CommandManager.this.handleCommandOnCurrentThread(finalEvent);
                    return;
                }
                if (!fp.runAction(new Runnable(){

                    @Override
                    public void run() {
                        CommandManager.this.handleCommandOnCurrentThread(finalEvent);
                    }
                }, false, true)) {
                    BBC.WORLDEDIT_COMMAND_LIMIT.send(fp, new Object[0]);
                }
                finalEvent.setCancelled(true);
            }
        }, Fawe.isMainThread());
    }

    @Subscribe
    public void handleCommandSuggestion(CommandSuggestionEvent event) {
        try {
            CommandLocals locals = new CommandLocals();
            locals.put(Actor.class, event.getActor());
            event.setSuggestions(this.dispatcher.getSuggestions(event.getArguments(), locals));
        }
        catch (CommandException e) {
            event.getActor().printError(e.getMessage());
        }
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public static Logger getLogger() {
        return commandLog;
    }
}

