/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.platform;

import com.sk89q.worldedit.NotABlockException;
import com.sk89q.worldedit.PlayerDirection;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BlockMaterial;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TargetBlock;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.io.File;

public abstract class AbstractPlayerActor
implements Actor,
Player,
Cloneable {
    @Override
    public final Extent getExtent() {
        return this.getWorld();
    }

    private static PlayerDirection getDirection(double rot) {
        if (0.0 <= rot && rot < 22.5) {
            return PlayerDirection.SOUTH;
        }
        if (22.5 <= rot && rot < 67.5) {
            return PlayerDirection.SOUTH_WEST;
        }
        if (67.5 <= rot && rot < 112.5) {
            return PlayerDirection.WEST;
        }
        if (112.5 <= rot && rot < 157.5) {
            return PlayerDirection.NORTH_WEST;
        }
        if (157.5 <= rot && rot < 202.5) {
            return PlayerDirection.NORTH;
        }
        if (202.5 <= rot && rot < 247.5) {
            return PlayerDirection.NORTH_EAST;
        }
        if (247.5 <= rot && rot < 292.5) {
            return PlayerDirection.EAST;
        }
        if (292.5 <= rot && rot < 337.5) {
            return PlayerDirection.SOUTH_EAST;
        }
        if (337.5 <= rot && rot < 360.0) {
            return PlayerDirection.SOUTH;
        }
        return null;
    }

    @Override
    public boolean isHoldingPickAxe() {
        ItemTypes item = this.getItemInHand(HandSide.MAIN_HAND).getType();
        return item == ItemTypes.IRON_PICKAXE || item == ItemTypes.WOODEN_PICKAXE || item == ItemTypes.STONE_PICKAXE || item == ItemTypes.DIAMOND_PICKAXE || item == ItemTypes.GOLDEN_PICKAXE;
    }

    @Override
    public void findFreePosition(Location searchPos) {
        int y;
        Extent world = searchPos.getExtent();
        int x = searchPos.getBlockX();
        int origY = y = Math.max(0, searchPos.getBlockY());
        int z = searchPos.getBlockZ();
        int free = 0;
        while (y <= world.getMaximumPoint().getBlockY() + 2) {
            free = !world.getBlock(new Vector(x, y, z)).getBlockType().getMaterial().isMovementBlocker() ? (int)((byte)(free + 1)) : 0;
            if (free == 2) {
                if (y - 1 != origY) {
                    Vector pos = new Vector(x, y - 2, z);
                    BlockState state = world.getBlock(pos);
                    this.setPosition(new Vector((double)x + 0.5, (double)(y - 2) + BlockType.centralTopLimit(state), (double)z + 0.5));
                }
                return;
            }
            ++y;
        }
    }

    @Override
    public void setOnGround(Location searchPos) {
        Extent world = searchPos.getExtent();
        int x = searchPos.getBlockX();
        int z = searchPos.getBlockZ();
        for (int y = Math.max(0, searchPos.getBlockY()); y >= 0; --y) {
            Vector pos = new Vector(x, y, z);
            BlockState id = world.getBlock(pos);
            if (!id.getBlockType().getMaterial().isMovementBlocker()) continue;
            this.setPosition(new Vector((double)x + 0.5, (double)y + BlockType.centralTopLimit(id), (double)z + 0.5));
            return;
        }
    }

    @Override
    public void findFreePosition() {
        this.findFreePosition(this.getBlockIn());
    }

    @Override
    public boolean ascendLevel() {
        Location pos = this.getBlockIn();
        int x = pos.getBlockX();
        int y = Math.max(0, pos.getBlockY());
        int z = pos.getBlockZ();
        Extent world = pos.getExtent();
        int maxY = world.getMaxY();
        if (y >= maxY) {
            return false;
        }
        BlockMaterial initialMaterial = world.getBlockType(new Vector(x, y, z)).getMaterial();
        boolean lastState = initialMaterial.isMovementBlocker() && initialMaterial.isFullCube();
        double height = 1.85;
        double freeStart = -1.0;
        for (int level = y + 1; level <= maxY + 2; ++level) {
            BlockState state = level >= maxY ? BlockTypes.VOID_AIR.getDefaultState() : world.getBlock(new Vector(x, level, z));
            BlockTypes type = state.getBlockType();
            BlockMaterial material = type.getMaterial();
            if (!material.isFullCube() || !material.isMovementBlocker()) {
                if (!lastState) {
                    lastState = BlockType.centralBottomLimit(state) != 1.0;
                    continue;
                }
                if (freeStart == -1.0) {
                    freeStart = (double)level + BlockType.centralTopLimit(state);
                    continue;
                }
                double bottomLimit = BlockType.centralBottomLimit(state);
                double space = (double)level + bottomLimit - freeStart;
                if (space >= height) {
                    this.setPosition(new Vector((double)x + 0.5, freeStart, (double)z + 0.5));
                    return true;
                }
                if (bottomLimit == 1.0) continue;
                freeStart = -1.0;
                continue;
            }
            freeStart = -1.0;
            lastState = true;
        }
        return false;
    }

    @Override
    public boolean descendLevel() {
        Location pos = this.getBlockIn();
        int x = pos.getBlockX();
        int y = Math.max(0, pos.getBlockY());
        int z = pos.getBlockZ();
        Extent world = pos.getExtent();
        BlockMaterial initialMaterial = world.getBlockType(new Vector(x, y, z)).getMaterial();
        boolean lastState = initialMaterial.isMovementBlocker() && initialMaterial.isFullCube();
        double height = 1.85;
        double freeEnd = -1.0;
        int maxY = world.getMaxY();
        if (y <= 2) {
            return false;
        }
        for (int level = y + 1; level > 0; --level) {
            BlockState state = level >= maxY ? BlockTypes.VOID_AIR.getDefaultState() : world.getBlock(new Vector(x, level, z));
            BlockTypes type = state.getBlockType();
            BlockMaterial material = type.getMaterial();
            if (!material.isFullCube() || !material.isMovementBlocker()) {
                if (!lastState) {
                    lastState = BlockType.centralTopLimit(state) != 0.0;
                    continue;
                }
                if (freeEnd == -1.0) {
                    freeEnd = (double)level + BlockType.centralBottomLimit(state);
                    continue;
                }
                double topLimit = BlockType.centralTopLimit(state);
                double freeStart = (double)level + topLimit;
                double space = freeEnd - freeStart;
                if (space >= height) {
                    this.setPosition(new Vector((double)x + 0.5, freeStart, (double)z + 0.5));
                    return true;
                }
                if (topLimit == 0.0) continue;
                freeEnd = -1.0;
                continue;
            }
            lastState = true;
            freeEnd = -1.0;
        }
        return false;
    }

    @Override
    public boolean ascendToCeiling(int clearance) {
        return this.ascendToCeiling(clearance, true);
    }

    @Override
    public boolean ascendToCeiling(int clearance, boolean alwaysGlass) {
        Location pos = this.getBlockIn();
        int x = pos.getBlockX();
        int initialY = Math.max(0, pos.getBlockY());
        int y = Math.max(0, pos.getBlockY() + 2);
        int z = pos.getBlockZ();
        Extent world = this.getLocation().getExtent();
        if (!world.getBlock(new Vector(x, y, z)).getBlockType().getMaterial().isAir()) {
            return false;
        }
        while ((double)y <= world.getMaximumPoint().getY()) {
            if (world.getBlock(new Vector(x, y, z)).getBlockType().getMaterial().isMovementBlocker()) {
                int platformY = Math.max(initialY, y - 3 - clearance);
                this.floatAt(x, platformY + 1, z, alwaysGlass);
                return true;
            }
            ++y;
        }
        return false;
    }

    @Override
    public boolean ascendUpwards(int distance) {
        return this.ascendUpwards(distance, true);
    }

    @Override
    public boolean ascendUpwards(int distance, boolean alwaysGlass) {
        Location pos = this.getBlockIn();
        int x = pos.getBlockX();
        int initialY = Math.max(0, pos.getBlockY());
        int z = pos.getBlockZ();
        int maxY = Math.min(this.getWorld().getMaxY() + 1, initialY + distance);
        Extent world = this.getLocation().getExtent();
        for (int y = Math.max(0, pos.getBlockY() + 1); (double)y <= world.getMaximumPoint().getY() + 2.0 && !world.getBlock(new Vector(x, y, z)).getBlockType().getMaterial().isMovementBlocker() && y <= maxY + 1; ++y) {
            if (y != maxY + 1) continue;
            this.floatAt(x, y - 1, z, alwaysGlass);
            return true;
        }
        return false;
    }

    @Override
    public void floatAt(int x, int y, int z, boolean alwaysGlass) {
        Vector spot = new Vector(x, y - 1, z);
        if (!this.getLocation().getExtent().getBlock(spot).getBlockType().getMaterial().isMovementBlocker()) {
            try {
                this.getLocation().getExtent().setBlock(new Vector(x, y - 1, z), BlockTypes.GLASS.getDefaultState());
            }
            catch (WorldEditException e) {
                e.printStackTrace();
            }
        }
        this.setPosition(new Vector((double)x + 0.5, (double)y, (double)z + 0.5));
    }

    @Override
    public Location getBlockIn() {
        Location loc = this.getLocation();
        return new Location(loc.getExtent(), loc.toBlockVector(), loc.getDirection());
    }

    @Override
    public Location getBlockOn() {
        return this.getLocation().setY(this.getLocation().getY() - 1.0);
    }

    @Override
    public Location getBlockTrace(int range, boolean useLastBlock) {
        TargetBlock tb = new TargetBlock(this, range, 0.2);
        return useLastBlock ? tb.getAnyTargetBlock() : tb.getTargetBlock();
    }

    @Override
    public Location getBlockTraceFace(int range, boolean useLastBlock) {
        TargetBlock tb = new TargetBlock(this, range, 0.2);
        return useLastBlock ? tb.getAnyTargetBlockFace() : tb.getTargetBlockFace();
    }

    @Override
    public Location getBlockTrace(int range) {
        return this.getBlockTrace(range, false);
    }

    @Override
    public Location getSolidBlockTrace(int range) {
        TargetBlock tb = new TargetBlock(this, range, 0.2);
        return tb.getSolidTargetBlock();
    }

    @Override
    public PlayerDirection getCardinalDirection() {
        return this.getCardinalDirection(0);
    }

    @Override
    public PlayerDirection getCardinalDirection(int yawOffset) {
        if ((double)this.getLocation().getPitch() > 67.5) {
            return PlayerDirection.DOWN;
        }
        if ((double)this.getLocation().getPitch() < -67.5) {
            return PlayerDirection.UP;
        }
        double rot = (this.getLocation().getYaw() + (float)yawOffset) % 360.0f;
        if (rot < 0.0) {
            rot += 360.0;
        }
        return AbstractPlayerActor.getDirection(rot);
    }

    @Override
    public BlockState getBlockInHand(HandSide handSide) throws WorldEditException {
        ItemTypes typeId = this.getItemInHand(handSide).getType();
        if (typeId.hasBlockType()) {
            return typeId.getBlockType().getDefaultState();
        }
        throw new NotABlockException();
    }

    @Override
    public boolean passThroughForwardWall(int range) {
        Location block;
        int searchDist = 0;
        TargetBlock hitBlox = new TargetBlock(this, range, 0.2);
        Extent world = this.getLocation().getExtent();
        boolean firstBlock = true;
        int freeToFind = 2;
        boolean inFree = false;
        while ((block = hitBlox.getNextBlock()) != null) {
            boolean free;
            boolean bl = free = !world.getBlock(block.toVector()).getBlockType().getMaterial().isMovementBlocker();
            if (firstBlock) {
                firstBlock = false;
                if (!free) {
                    --freeToFind;
                    continue;
                }
            }
            if (++searchDist > 20) {
                return false;
            }
            if (inFree != free && free) {
                --freeToFind;
            }
            if (freeToFind == 0) {
                this.setOnGround(block);
                return true;
            }
            inFree = free;
        }
        return false;
    }

    @Override
    public void setPosition(Vector pos) {
        this.setPosition(pos, this.getLocation().getPitch(), this.getLocation().getYaw());
    }

    @Override
    public File openFileOpenDialog(String[] extensions) {
        this.printError("File dialogs are not supported in your environment.");
        return null;
    }

    @Override
    public File openFileSaveDialog(String[] extensions) {
        this.printError("File dialogs are not supported in your environment.");
        return null;
    }

    @Override
    public boolean canDestroyBedrock() {
        return this.hasPermission("worldedit.override.bedrock");
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
    }

    public boolean equals(Object other) {
        if (!(other instanceof Player)) {
            return false;
        }
        Player other2 = (Player)other;
        return other2.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public void checkPermission(String permission) throws AuthorizationException {
        if (!this.hasPermission(permission)) {
            throw new AuthorizationException();
        }
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @Override
    public GameMode getGameMode() {
        return GameModes.SURVIVAL;
    }

    @Override
    public void setGameMode(GameMode gameMode) {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Not supported");
    }

    @Override
    public boolean remove() {
        return false;
    }
}

