/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool;

import com.boydti.fawe.config.BBC;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.command.tool.BrushTool;
import com.sk89q.worldedit.command.tool.DoubleActionTraceTool;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class LongRangeBuildTool
extends BrushTool
implements DoubleActionTraceTool {
    private Pattern primary;
    private Pattern secondary;

    public LongRangeBuildTool(Pattern secondary, Pattern primary) {
        super("worldedit.tool.lrbuild");
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public boolean canUse(Actor player) {
        return player.hasPermission("worldedit.tool.lrbuild");
    }

    @Override
    public boolean actSecondary(Platform server, LocalConfiguration config, Player player, LocalSession session) {
        Location pos = this.getTargetFace(player);
        if (pos == null) {
            return false;
        }
        EditSession eS = session.createEditSession(player);
        BlockStateHolder applied = this.secondary.apply(pos.toVector());
        if (applied.getBlockType().getMaterial().isAir()) {
            eS.setBlock(pos.toVector(), this.secondary);
        } else {
            eS.setBlock(pos.add(pos.getDirection()), this.secondary);
        }
        return true;
    }

    @Override
    public boolean actPrimary(Platform server, LocalConfiguration config, Player player, LocalSession session) {
        Location pos = this.getTargetFace(player);
        if (pos == null) {
            return false;
        }
        EditSession eS = session.createEditSession(player);
        BlockStateHolder applied = this.primary.apply(pos.toVector());
        if (applied.getBlockType().getMaterial().isAir()) {
            eS.setBlock(pos.toVector(), this.primary);
        } else {
            eS.setBlock(pos.add(pos.getDirection()), this.primary);
        }
        return true;
    }

    public Location getTargetFace(Player player) {
        Location target = player.getBlockTraceFace(this.getRange(), true);
        if (target == null) {
            BBC.NO_BLOCK.send(player, new Object[0]);
            return null;
        }
        return target;
    }
}

