/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.brush.BrushSettings;
import com.boydti.fawe.object.brush.MovableTool;
import com.boydti.fawe.object.brush.ResettableTool;
import com.boydti.fawe.object.brush.TargetMode;
import com.boydti.fawe.object.brush.scroll.ScrollAction;
import com.boydti.fawe.object.brush.scroll.ScrollTool;
import com.boydti.fawe.object.brush.visualization.VisualChunk;
import com.boydti.fawe.object.brush.visualization.VisualExtent;
import com.boydti.fawe.object.brush.visualization.VisualMode;
import com.boydti.fawe.object.extent.ResettableExtent;
import com.boydti.fawe.object.mask.MaskedTargetBlock;
import com.boydti.fawe.object.pattern.PatternTraverser;
import com.boydti.fawe.util.BrushCache;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.MaskTraverser;
import com.boydti.fawe.util.StringMan;
import com.boydti.fawe.util.TaskManager;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.command.tool.DoubleActionTraceTool;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.mask.SolidBlockMask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.session.request.Request;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.block.BlockType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;

public class BrushTool
implements DoubleActionTraceTool,
ScrollTool,
MovableTool,
ResettableTool,
Serializable {
    protected static int MAX_RANGE = 500;
    protected int range = 240;
    private VisualMode visualMode = VisualMode.NONE;
    private TargetMode targetMode = TargetMode.TARGET_BLOCK_RANGE;
    private Mask targetMask = null;
    private int targetOffset;
    private transient BrushSettings primary = new BrushSettings();
    private transient BrushSettings secondary = new BrushSettings();
    private transient BrushSettings context = this.primary;
    private transient VisualExtent visualExtent;
    private transient Lock lock = new ReentrantLock();
    private transient BaseItem holder;

    public BrushTool(String permission) {
        this.getContext().addPermission(permission);
    }

    public BrushTool() {
    }

    public static BrushTool fromString(Player player, LocalSession session, String json) throws CommandException, InputParseException {
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map root = (Map)gson.fromJson(json, type);
        if (root == null) {
            Fawe.debug("Failed to load " + json);
            return new BrushTool();
        }
        Map primary = (Map)root.get("primary");
        Map secondary = root.getOrDefault("secondary", primary);
        VisualMode visual = VisualMode.valueOf(root.getOrDefault("visual", "NONE"));
        TargetMode target = TargetMode.valueOf(root.getOrDefault("target", "TARGET_BLOCK_RANGE"));
        int range = ((Number)root.getOrDefault("range", -1)).intValue();
        int offset = ((Number)root.getOrDefault("offset", 0)).intValue();
        BrushTool tool = new BrushTool();
        tool.visualMode = visual;
        tool.targetMode = target;
        tool.range = range;
        tool.targetOffset = offset;
        BrushSettings primarySettings = BrushSettings.get(tool, player, session, primary);
        tool.setPrimary(primarySettings);
        if (primary != secondary) {
            BrushSettings secondarySettings = BrushSettings.get(tool, player, session, secondary);
            tool.setSecondary(secondarySettings);
        }
        return tool;
    }

    public void setHolder(BaseItem holder) {
        this.holder = holder;
    }

    public boolean isSet() {
        return this.primary.getBrush() != null || this.secondary.getBrush() != null;
    }

    public String toString() {
        return this.toString(new Gson());
    }

    public String toString(Gson gson) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("primary", this.primary.getSettings());
        if (this.primary != this.secondary) {
            map.put("secondary", this.secondary.getSettings());
        }
        if (this.visualMode != null && this.visualMode != VisualMode.NONE) {
            map.put("visual", (Object)this.visualMode);
        }
        if (this.targetMode != TargetMode.TARGET_BLOCK_RANGE) {
            map.put("target", (Object)this.targetMode);
        }
        if (this.range != -1 && this.range != 240) {
            map.put("range", this.range);
        }
        if (this.targetOffset != 0) {
            map.put("offset", this.targetOffset);
        }
        return gson.toJson(map);
    }

    public void update() {
        if (this.holder != null) {
            BrushCache.setTool(this.holder, this);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeBoolean(this.primary == this.secondary);
        stream.writeObject(this.primary);
        if (this.primary != this.secondary) {
            stream.writeObject(this.secondary);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.lock = new ReentrantLock();
        boolean multi = stream.readBoolean();
        this.primary = (BrushSettings)stream.readObject();
        this.secondary = multi ? (BrushSettings)stream.readObject() : this.primary;
        this.context = this.primary;
    }

    public BrushSettings getContext() {
        BrushSettings tmp = this.context;
        if (tmp == null) {
            this.context = tmp = this.primary;
        }
        return tmp;
    }

    public void setContext(BrushSettings context) {
        this.context = context;
    }

    @Override
    public boolean canUse(Actor player) {
        if (this.primary == this.secondary) {
            return this.primary.canUse(player);
        }
        return this.primary.canUse(player) && this.secondary.canUse(player);
    }

    public ResettableExtent getTransform() {
        return this.getContext().getTransform();
    }

    public BrushSettings getPrimary() {
        return this.primary;
    }

    public BrushSettings getSecondary() {
        return this.secondary;
    }

    public BrushSettings getOffHand() {
        return this.context == this.primary ? this.secondary : this.primary;
    }

    public void setPrimary(BrushSettings primary) {
        Preconditions.checkNotNull((Object)primary);
        this.primary = primary;
        this.context = primary;
        this.update();
    }

    public void setSecondary(BrushSettings secondary) {
        Preconditions.checkNotNull((Object)secondary);
        this.secondary = secondary;
        this.context = secondary;
        this.update();
    }

    public void setTransform(ResettableExtent transform) {
        this.getContext().setTransform(transform);
        this.update();
    }

    public Mask getMask() {
        return this.getContext().getMask();
    }

    public Mask getSourceMask() {
        return this.getContext().getSourceMask();
    }

    @Override
    public boolean reset() {
        Brush br = this.getBrush();
        if (br instanceof ResettableTool) {
            return ((ResettableTool)((Object)br)).reset();
        }
        return false;
    }

    public void setMask(Mask filter) {
        this.getContext().setMask(filter);
        this.update();
    }

    public void setSourceMask(Mask filter) {
        this.getContext().setSourceMask(filter);
        this.update();
    }

    @Deprecated
    public void setBrush(Brush brush, String permission) {
        this.setBrush(brush, permission, null);
        this.update();
    }

    @Deprecated
    public void setBrush(Brush brush, String permission, Player player) {
        if (player != null) {
            this.clear(player);
        }
        BrushSettings current = this.getContext();
        current.clearPerms();
        current.setBrush(brush);
        current.addPermission(permission);
        this.update();
    }

    public Brush getBrush() {
        return this.getContext().getBrush();
    }

    public void setFill(@Nullable Pattern material) {
        this.getContext().setFill(material);
    }

    @Nullable
    public Pattern getMaterial() {
        return this.getContext().getMaterial();
    }

    public double getSize() {
        return this.getContext().getSize();
    }

    public void setSize(double radius) {
        this.getContext().setSize(radius);
    }

    public void setSize(Expression radius) {
        this.getContext().setSize(radius);
    }

    public int getRange() {
        return this.range < 0 ? MAX_RANGE : Math.min(this.range, MAX_RANGE);
    }

    public void setRange(int range) {
        this.range = range;
    }

    public Vector getPosition(EditSession editSession, Player player) {
        Location loc = player.getLocation();
        switch (this.targetMode) {
            case TARGET_BLOCK_RANGE: {
                return this.offset(new MutableBlockVector(this.trace(editSession, player, this.getRange(), true)), loc.toVector());
            }
            case FOWARD_POINT_PITCH: {
                int d = 0;
                float pitch = loc.getPitch();
                pitch = 23.0f - pitch / 4.0f;
                Vector vector = loc.getDirection().setY(0).normalize().multiply(d += (int)(Math.sin(Math.toRadians(pitch)) * 50.0));
                vector.add(loc.getX(), loc.getY(), loc.getZ()).toBlockVector();
                return this.offset(new MutableBlockVector(vector), loc.toVector());
            }
            case TARGET_POINT_HEIGHT: {
                BlockType block;
                int y;
                int height = loc.getBlockY();
                int x = loc.getBlockX();
                int z = loc.getBlockZ();
                for (y = height; y > 0 && !(block = editSession.getBlockType(x, y, z)).getMaterial().isMovementBlocker(); --y) {
                }
                int distance = height - y + 8;
                return this.offset(new MutableBlockVector(this.trace(editSession, player, distance, true)), loc.toVector());
            }
            case TARGET_FACE_RANGE: {
                return this.offset(new MutableBlockVector(this.trace(editSession, player, this.getRange(), true)), loc.toVector());
            }
        }
        return null;
    }

    private Vector offset(Vector target, Vector playerPos) {
        if (this.targetOffset == 0) {
            return target;
        }
        return target.subtract(target.subtract(playerPos).normalize().multiply(this.targetOffset));
    }

    private Vector trace(EditSession editSession, Player player, int range, final boolean useLastBlock) {
        Mask mask = this.targetMask == null ? new SolidBlockMask(editSession) : this.targetMask;
        new MaskTraverser(mask).reset(editSession);
        final MaskedTargetBlock tb = new MaskedTargetBlock(mask, player, range, 0.2);
        return TaskManager.IMP.sync(new RunnableVal<Vector>(){

            @Override
            public void run(Vector value) {
                Location result = tb.getMaskedTargetBlock(useLastBlock);
                this.value = result.toVector();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean act(BrushAction action, Platform server, LocalConfiguration config, Player player, LocalSession session) {
        ResettableExtent transform;
        Mask sourceMask;
        switch (action) {
            case PRIMARY: {
                this.setContext(this.primary);
                break;
            }
            case SECONDARY: {
                this.setContext(this.secondary);
            }
        }
        BrushSettings current = this.getContext();
        Brush brush = current.getBrush();
        if (brush == null) {
            return false;
        }
        EditSession editSession = session.createEditSession(player);
        if (current.setWorld(editSession.getWorld().getName()) && !current.canUse(player)) {
            BBC.NO_PERM.send(player, StringMan.join(current.getPermissions(), ","));
            return false;
        }
        Vector target = this.getPosition(editSession, player);
        if (target == null) {
            editSession.cancel();
            BBC.NO_BLOCK.send(player, new Object[0]);
            return false;
        }
        BlockBag bag = session.getBlockBag(player);
        Request.request().setEditSession(editSession);
        Mask mask = current.getMask();
        if (mask != null) {
            Mask existingMask = editSession.getMask();
            if (existingMask == null) {
                editSession.setMask(mask);
            } else if (existingMask instanceof MaskIntersection) {
                ((MaskIntersection)existingMask).add(mask);
            } else {
                MaskIntersection newMask = new MaskIntersection(existingMask);
                newMask.add(mask);
                editSession.setMask(newMask);
            }
        }
        if ((sourceMask = current.getSourceMask()) != null) {
            editSession.addSourceMask(sourceMask);
        }
        if ((transform = current.getTransform()) != null) {
            editSession.addTransform(transform);
        }
        try {
            new PatternTraverser(current).reset(editSession);
            double size = current.getSize();
            WorldEdit.getInstance().checkMaxBrushRadius(size);
            brush.build(editSession, target, current.getMaterial(), size);
        }
        catch (WorldEditException e) {
            player.printError("Max blocks change limit reached.");
        }
        finally {
            if (bag != null) {
                bag.flushChanges();
            }
            session.remember(editSession);
            Request.reset();
        }
        return true;
    }

    @Override
    public boolean actPrimary(Platform server, LocalConfiguration config, Player player, LocalSession session) {
        return this.act(BrushAction.PRIMARY, server, config, player, session);
    }

    @Override
    public boolean actSecondary(Platform server, LocalConfiguration config, Player player, LocalSession session) {
        return this.act(BrushAction.SECONDARY, server, config, player, session);
    }

    public void setScrollAction(ScrollAction scrollAction) {
        this.getContext().setScrollAction(scrollAction);
        this.update();
    }

    public void setTargetOffset(int targetOffset) {
        this.targetOffset = targetOffset;
        this.update();
    }

    public void setTargetMode(TargetMode targetMode) {
        this.targetMode = targetMode != null ? targetMode : TargetMode.TARGET_BLOCK_RANGE;
        this.update();
    }

    public void setTargetMask(Mask mask) {
        this.targetMask = mask;
        this.update();
    }

    public void setVisualMode(Player player, VisualMode visualMode) {
        if (visualMode == null) {
            visualMode = VisualMode.NONE;
        }
        if (this.visualMode != visualMode) {
            if (this.visualMode != VisualMode.NONE) {
                this.clear(player);
            }
            VisualMode visualMode2 = this.visualMode = visualMode != null ? visualMode : VisualMode.NONE;
            if (visualMode != VisualMode.NONE) {
                try {
                    this.queueVisualization(FawePlayer.wrap(player));
                }
                catch (Throwable e) {
                    WorldEdit.getInstance().getPlatformManager().handleThrowable(e, player);
                }
            }
        }
        this.update();
    }

    public TargetMode getTargetMode() {
        return this.targetMode;
    }

    public int getTargetOffset() {
        return this.targetOffset;
    }

    public Mask getTargetMask() {
        return this.targetMask;
    }

    public VisualMode getVisualMode() {
        return this.visualMode;
    }

    @Override
    public boolean increment(Player player, int amount) {
        BrushSettings current = this.getContext();
        ScrollAction tmp = current.getScrollAction();
        if (tmp != null) {
            tmp.setTool(this);
            if (tmp.increment(player, amount)) {
                if (this.visualMode != VisualMode.NONE) {
                    try {
                        this.queueVisualization(FawePlayer.wrap(player));
                    }
                    catch (Throwable e) {
                        WorldEdit.getInstance().getPlatformManager().handleThrowable(e, player);
                    }
                }
                return true;
            }
        }
        if (this.visualMode != VisualMode.NONE) {
            this.clear(player);
        }
        return false;
    }

    public void queueVisualization(FawePlayer player) {
        Fawe.get().getVisualQueue().queue(player);
    }

    @Deprecated
    public synchronized void visualize(BrushAction action, Player player) throws WorldEditException {
        VisualMode mode = this.getVisualMode();
        if (mode == VisualMode.NONE) {
            return;
        }
        BrushSettings current = this.getContext();
        Brush brush = current.getBrush();
        if (brush == null) {
            return;
        }
        FawePlayer fp = FawePlayer.wrap(player);
        EditSession editSession = new EditSessionBuilder(player.getWorld()).player(fp).allowedRegionsEverywhere().autoQueue(false).blockBag(null).changeSetNull().combineStages(false).build();
        VisualExtent newVisualExtent = new VisualExtent(editSession.getExtent(), editSession.getQueue());
        Vector position = this.getPosition(editSession, player);
        if (position != null) {
            editSession.setExtent(newVisualExtent);
            switch (mode) {
                case POINT: {
                    editSession.setBlock(position, VisualChunk.VISUALIZE_BLOCK);
                    break;
                }
                case OUTLINE: {
                    new PatternTraverser(current).reset(editSession);
                    brush.build(editSession, position, current.getMaterial(), current.getSize());
                }
            }
        }
        if (this.visualExtent != null) {
            this.visualExtent.clear(newVisualExtent, fp);
        }
        this.visualExtent = newVisualExtent;
        newVisualExtent.visualize(fp);
    }

    public void clear(Player player) {
        FawePlayer fp = FawePlayer.wrap(player);
        Fawe.get().getVisualQueue().dequeue(fp);
        if (this.visualExtent != null) {
            this.visualExtent.clear(null, fp);
        }
    }

    @Override
    public boolean move(Player player) {
        if (this.visualMode != VisualMode.NONE) {
            this.queueVisualization(FawePlayer.wrap(player));
            return true;
        }
        return false;
    }

    public static enum BrushAction {
        PRIMARY,
        SECONDARY;

    }
}

