/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.command.tool.DoubleActionBlockTool;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;

public class BlockDataCyler
implements DoubleActionBlockTool {
    @Override
    public boolean canUse(Actor player) {
        return player.hasPermission("worldedit.tool.data-cycler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleCycle(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked, boolean forward) {
        World world = (World)clicked.getExtent();
        BlockState block = world.getBlock(clicked.toVector());
        if (!(config.allowedDataCycleBlocks.isEmpty() || player.hasPermission("worldedit.override.data-cycler") || config.allowedDataCycleBlocks.contains(block.getBlockType().getId()))) {
            player.printError("You are not permitted to cycle the data value of that block.");
            return true;
        }
        if (block.getBlockType().getProperties().isEmpty()) {
            player.printError("That block's data cannot be cycled!");
        } else {
            BlockState newBlock = block;
            EditSession editSession = session.createEditSession(player);
            try {
                editSession.setBlock(clicked.toVector(), newBlock);
            }
            catch (MaxChangedBlocksException e) {
                player.printError("Max blocks change limit reached.");
            }
            finally {
                session.remember(editSession);
            }
        }
        return true;
    }

    @Override
    public boolean actPrimary(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked) {
        return this.handleCycle(server, config, player, session, clicked, true);
    }

    @Override
    public boolean actSecondary(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked) {
        return this.handleCycle(server, config, player, session, clicked, false);
    }
}

