/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.brush.BrushSettings;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.MethodCommands;
import com.sk89q.worldedit.command.tool.BrushTool;
import com.sk89q.worldedit.command.tool.InvalidToolBindException;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.command.CallableProcessor;
import com.sk89q.worldedit.util.command.CommandCallable;
import com.sk89q.worldedit.util.command.parametric.AParametricCallable;

public class BrushProcessor
extends MethodCommands
implements CallableProcessor<BrushSettings> {
    private final WorldEdit worldEdit;

    public BrushProcessor(WorldEdit worldEdit) {
        this.worldEdit = worldEdit;
    }

    public WorldEdit getWorldEdit() {
        return this.worldEdit;
    }

    public BrushSettings process(CommandLocals locals, BrushSettings settings) throws WorldEditException {
        Actor actor = locals.get(Actor.class);
        LocalSession session = this.worldEdit.getSessionManager().get(actor);
        session.setTool(null, (Player)actor);
        BrushTool tool = session.getBrushTool((Player)actor);
        if (tool != null) {
            tool.setPrimary(settings);
            tool.setSecondary(settings);
            BBC.BRUSH_EQUIPPED.send(actor, ((String)locals.get("arguments")).split(" ")[1]);
        }
        return null;
    }

    public BrushSettings set(LocalSession session, CommandContext context, Brush brush) throws InvalidToolBindException {
        String args;
        CommandCallable callable;
        Brush currentBrush;
        BrushSettings currentContext;
        CommandLocals locals = context.getLocals();
        Actor actor = locals.get(Actor.class);
        BrushSettings bs = new BrushSettings();
        BrushTool tool = session.getBrushTool((Player)actor, false);
        if (tool != null && (currentContext = tool.getContext()) != null && (currentBrush = currentContext.getBrush()) != null && currentBrush.getClass() == brush.getClass()) {
            bs = currentContext;
        }
        String[] perms = (callable = locals.get(CommandCallable.class)) != null && callable instanceof AParametricCallable ? ((AParametricCallable)callable).getPermissions() : this.getPermissions();
        bs.addPermissions(perms);
        if (locals != null && (args = (String)locals.get("arguments")) != null) {
            bs.addSetting(BrushSettings.SettingType.BRUSH, args.substring(args.indexOf(32) + 1));
        }
        return bs.setBrush(brush);
    }
}

