/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.bukkit.adapter.CachedBukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;

public class SimpleBukkitAdapter
extends CachedBukkitAdapter {
    private BlockData[][] blockDataCache;

    public boolean init() {
        if (this.blockDataCache != null) {
            return false;
        }
        this.blockDataCache = new BlockData[BlockTypes.size()][];
        this.blockDataCache[0] = new BlockData[]{Material.AIR.createBlockData()};
        return true;
    }

    @Override
    public BlockData adapt(BlockStateHolder block) {
        try {
            int propId;
            BlockData blockData;
            Preconditions.checkNotNull((Object)block);
            int typeId = block.getInternalBlockTypeId();
            BlockData[] dataCache = this.blockDataCache[typeId];
            if (dataCache == null) {
                BlockTypes type = BlockTypes.get(typeId);
                dataCache = new BlockData[type.getMaxStateId() + 1];
                this.blockDataCache[typeId] = dataCache;
            }
            if ((blockData = dataCache[propId = block.getInternalPropertiesId()]) == null) {
                dataCache[propId] = blockData = Bukkit.createBlockData((String)block.getAsString());
            }
            return blockData;
        }
        catch (NullPointerException e) {
            if (this.init()) {
                return this.adapt(block);
            }
            throw e;
        }
    }
}

