/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.util.TaskManager;
import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayerBlockBag;
import com.sk89q.worldedit.bukkit.CUIChannelListener;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.AbstractPlayerActor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class BukkitPlayer
extends AbstractPlayerActor {
    private Player player;
    private WorldEditPlugin plugin;

    public BukkitPlayer(WorldEditPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public BaseItemStack getItemInHand(HandSide handSide) {
        ItemStack itemStack = handSide == HandSide.MAIN_HAND ? this.player.getInventory().getItemInMainHand() : this.player.getInventory().getItemInOffHand();
        return BukkitAdapter.adapt(itemStack);
    }

    @Override
    public BlockState getBlockInHand(HandSide handSide) throws WorldEditException {
        ItemStack itemStack = handSide == HandSide.MAIN_HAND ? this.player.getInventory().getItemInMainHand() : this.player.getInventory().getItemInOffHand();
        return BukkitAdapter.asBlockState(itemStack);
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public void giveItem(BaseItemStack itemStack) {
        HashMap overflow;
        PlayerInventory inv = this.player.getInventory();
        ItemStack newItem = BukkitAdapter.adapt(itemStack);
        if (itemStack.getType() == WorldEdit.getInstance().getConfiguration().wandItem) {
            inv.remove(newItem);
        }
        ItemStack item = this.player.getItemInHand();
        this.player.setItemInHand(newItem);
        if (item != null && (overflow = inv.addItem(new ItemStack[]{item})) != null && !overflow.isEmpty()) {
            TaskManager.IMP.sync(new RunnableVal<Object>(){

                @Override
                public void run(Object value) {
                    for (Map.Entry entry : overflow.entrySet()) {
                        ItemStack stack = (ItemStack)entry.getValue();
                        if (stack.getType() == Material.AIR || stack.getAmount() <= 0) continue;
                        Item dropped = BukkitPlayer.this.player.getWorld().dropItem(BukkitPlayer.this.player.getLocation(), stack);
                        PlayerDropItemEvent event = new PlayerDropItemEvent(BukkitPlayer.this.player, dropped);
                        if (!event.isCancelled()) continue;
                        dropped.remove();
                    }
                }
            });
        }
        this.player.updateInventory();
    }

    @Override
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage(part);
        }
    }

    @Override
    public void print(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7d" + part);
        }
    }

    @Override
    public void printDebug(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a77" + part);
        }
    }

    @Override
    public void printError(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7c" + part);
        }
    }

    @Override
    public void setPosition(Vector pos, float pitch, float yaw) {
        this.player.teleport(new Location(this.player.getWorld(), pos.getX(), pos.getY(), pos.getZ(), yaw, pitch));
    }

    @Override
    public String[] getGroups() {
        return this.plugin.getPermissionsResolver().getGroups((OfflinePlayer)this.player);
    }

    @Override
    public BlockBag getInventoryBlockBag() {
        return new BukkitPlayerBlockBag(this.player);
    }

    @Override
    public GameMode getGameMode() {
        return GameModes.get(this.player.getGameMode().name().toLowerCase());
    }

    @Override
    public void setGameMode(GameMode gameMode) {
        this.player.setGameMode(org.bukkit.GameMode.valueOf((String)gameMode.getId().toUpperCase()));
    }

    @Override
    public boolean hasPermission(String perm) {
        return !this.plugin.getLocalConfiguration().noOpPermissions && this.player.isOp() || this.plugin.getPermissionsResolver().hasPermission(this.player.getWorld().getName(), (OfflinePlayer)this.player, perm);
    }

    @Override
    public World getWorld() {
        return BukkitAdapter.adapt(this.player.getWorld());
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        String send = event.getTypeId();
        if (params.length > 0) {
            send = send + "|" + StringUtil.joinString(params, "|");
        }
        this.player.sendPluginMessage((Plugin)this.plugin, WorldEditPlugin.getCuiPluginChannel(), send.getBytes(CUIChannelListener.UTF_8_CHARSET));
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void floatAt(int x, int y, int z, boolean alwaysGlass) {
        if (alwaysGlass || !this.player.getAllowFlight()) {
            super.floatAt(x, y, z, alwaysGlass);
            return;
        }
        this.setPosition(new Vector((double)x + 0.5, (double)y, (double)z + 0.5));
        this.player.setFlying(true);
    }

    @Override
    public BaseEntity getState() {
        throw new UnsupportedOperationException("Cannot create a state from this object");
    }

    @Override
    public com.sk89q.worldedit.util.Location getLocation() {
        Location nativeLocation = this.player.getLocation();
        Vector position = BukkitAdapter.asVector(nativeLocation);
        return new com.sk89q.worldedit.util.Location((Extent)this.getWorld(), position, nativeLocation.getYaw(), nativeLocation.getPitch());
    }

    @Override
    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return null;
    }

    @Override
    public SessionKey getSessionKey() {
        return new SessionKeyImpl(this.player.getUniqueId(), this.player.getName());
    }

    private static class SessionKeyImpl
    implements SessionKey {
        private final UUID uuid;
        private final String name;

        private SessionKeyImpl(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        @Override
        public UUID getUniqueId() {
            return this.uuid;
        }

        @Override
        @Nullable
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isActive() {
            return Bukkit.getServer().getPlayer(this.uuid) != null;
        }

        @Override
        public boolean isPersistent() {
            return true;
        }
    }
}

