/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class Blocks {
    private static final Set<BlockType> shouldPlaceLast = new HashSet<BlockType>();
    private static final Set<BlockType> shouldPlaceFinal;

    private Blocks() {
    }

    public static boolean shouldPlaceLast(BlockType type) {
        return shouldPlaceLast.contains(type);
    }

    public static boolean shouldPlaceFinal(BlockType type) {
        return shouldPlaceFinal.contains(type);
    }

    public static boolean containsFuzzy(Collection<? extends BlockStateHolder> collection, BlockStateHolder o) {
        for (BlockStateHolder blockStateHolder : collection) {
            if (!blockStateHolder.equalsFuzzy(o)) continue;
            return true;
        }
        return false;
    }

    static {
        shouldPlaceLast.addAll(BlockCategories.SAPLINGS.getAll());
        shouldPlaceLast.addAll(BlockCategories.FLOWER_POTS.getAll());
        shouldPlaceLast.addAll(BlockCategories.BUTTONS.getAll());
        shouldPlaceLast.addAll(BlockCategories.ANVIL.getAll());
        shouldPlaceLast.addAll(BlockCategories.WOODEN_PRESSURE_PLATES.getAll());
        shouldPlaceLast.addAll(BlockCategories.CARPETS.getAll());
        shouldPlaceLast.addAll(BlockCategories.RAILS.getAll());
        shouldPlaceLast.add(BlockTypes.BLACK_BED);
        shouldPlaceLast.add(BlockTypes.BLUE_BED);
        shouldPlaceLast.add(BlockTypes.BROWN_BED);
        shouldPlaceLast.add(BlockTypes.CYAN_BED);
        shouldPlaceLast.add(BlockTypes.GRAY_BED);
        shouldPlaceLast.add(BlockTypes.GREEN_BED);
        shouldPlaceLast.add(BlockTypes.LIGHT_BLUE_BED);
        shouldPlaceLast.add(BlockTypes.LIGHT_GRAY_BED);
        shouldPlaceLast.add(BlockTypes.LIME_BED);
        shouldPlaceLast.add(BlockTypes.MAGENTA_BED);
        shouldPlaceLast.add(BlockTypes.ORANGE_BED);
        shouldPlaceLast.add(BlockTypes.PINK_BED);
        shouldPlaceLast.add(BlockTypes.PURPLE_BED);
        shouldPlaceLast.add(BlockTypes.RED_BED);
        shouldPlaceLast.add(BlockTypes.WHITE_BED);
        shouldPlaceLast.add(BlockTypes.YELLOW_BED);
        shouldPlaceLast.add(BlockTypes.GRASS);
        shouldPlaceLast.add(BlockTypes.TALL_GRASS);
        shouldPlaceLast.add(BlockTypes.ROSE_BUSH);
        shouldPlaceLast.add(BlockTypes.DANDELION);
        shouldPlaceLast.add(BlockTypes.BROWN_MUSHROOM);
        shouldPlaceLast.add(BlockTypes.RED_MUSHROOM);
        shouldPlaceLast.add(BlockTypes.FERN);
        shouldPlaceLast.add(BlockTypes.LARGE_FERN);
        shouldPlaceLast.add(BlockTypes.OXEYE_DAISY);
        shouldPlaceLast.add(BlockTypes.AZURE_BLUET);
        shouldPlaceLast.add(BlockTypes.TORCH);
        shouldPlaceLast.add(BlockTypes.WALL_TORCH);
        shouldPlaceLast.add(BlockTypes.FIRE);
        shouldPlaceLast.add(BlockTypes.REDSTONE_WIRE);
        shouldPlaceLast.add(BlockTypes.CARROTS);
        shouldPlaceLast.add(BlockTypes.POTATOES);
        shouldPlaceLast.add(BlockTypes.WHEAT);
        shouldPlaceLast.add(BlockTypes.BEETROOTS);
        shouldPlaceLast.add(BlockTypes.COCOA);
        shouldPlaceLast.add(BlockTypes.LADDER);
        shouldPlaceLast.add(BlockTypes.LEVER);
        shouldPlaceLast.add(BlockTypes.REDSTONE_TORCH);
        shouldPlaceLast.add(BlockTypes.REDSTONE_WALL_TORCH);
        shouldPlaceLast.add(BlockTypes.SNOW);
        shouldPlaceLast.add(BlockTypes.NETHER_PORTAL);
        shouldPlaceLast.add(BlockTypes.END_PORTAL);
        shouldPlaceLast.add(BlockTypes.REPEATER);
        shouldPlaceLast.add(BlockTypes.VINE);
        shouldPlaceLast.add(BlockTypes.LILY_PAD);
        shouldPlaceLast.add(BlockTypes.NETHER_WART);
        shouldPlaceLast.add(BlockTypes.PISTON);
        shouldPlaceLast.add(BlockTypes.STICKY_PISTON);
        shouldPlaceLast.add(BlockTypes.TRIPWIRE_HOOK);
        shouldPlaceLast.add(BlockTypes.TRIPWIRE);
        shouldPlaceLast.add(BlockTypes.STONE_PRESSURE_PLATE);
        shouldPlaceLast.add(BlockTypes.HEAVY_WEIGHTED_PRESSURE_PLATE);
        shouldPlaceLast.add(BlockTypes.LIGHT_WEIGHTED_PRESSURE_PLATE);
        shouldPlaceLast.add(BlockTypes.COMPARATOR);
        shouldPlaceLast.add(BlockTypes.IRON_TRAPDOOR);
        shouldPlaceLast.add(BlockTypes.ACACIA_TRAPDOOR);
        shouldPlaceLast.add(BlockTypes.BIRCH_TRAPDOOR);
        shouldPlaceLast.add(BlockTypes.DARK_OAK_TRAPDOOR);
        shouldPlaceLast.add(BlockTypes.JUNGLE_TRAPDOOR);
        shouldPlaceLast.add(BlockTypes.OAK_TRAPDOOR);
        shouldPlaceLast.add(BlockTypes.SPRUCE_TRAPDOOR);
        shouldPlaceLast.add(BlockTypes.DAYLIGHT_DETECTOR);
        shouldPlaceFinal = new HashSet<BlockType>();
        shouldPlaceFinal.addAll(BlockCategories.DOORS.getAll());
        shouldPlaceFinal.addAll(BlockCategories.BANNERS.getAll());
        shouldPlaceFinal.add(BlockTypes.SIGN);
        shouldPlaceFinal.add(BlockTypes.WALL_SIGN);
        shouldPlaceFinal.add(BlockTypes.CACTUS);
        shouldPlaceFinal.add(BlockTypes.SUGAR_CANE);
        shouldPlaceFinal.add(BlockTypes.CAKE);
        shouldPlaceFinal.add(BlockTypes.PISTON_HEAD);
        shouldPlaceFinal.add(BlockTypes.MOVING_PISTON);
    }
}

