/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.worldedit.BlockVector2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class MutableBlockVector2D
extends BlockVector2D
implements Serializable {
    private static ThreadLocal<MutableBlockVector2D> MUTABLE_CACHE = new ThreadLocal<MutableBlockVector2D>(){

        @Override
        protected MutableBlockVector2D initialValue() {
            return new MutableBlockVector2D();
        }
    };
    private transient int x = 0;
    private transient int z = 0;

    public static MutableBlockVector2D get(int x, int z) {
        return MUTABLE_CACHE.get().setComponents(x, z);
    }

    public MutableBlockVector2D() {
        super(0, 0);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public int getBlockX() {
        return this.x;
    }

    @Override
    public int getBlockZ() {
        return this.z;
    }

    public MutableBlockVector2D setComponents(int x, int z) {
        this.x = x;
        this.z = z;
        return this;
    }

    public MutableBlockVector2D setComponents(double x, double z) {
        return this.setComponents((int)x, (int)z);
    }

    public final void mutX(int x) {
        this.x = x;
    }

    public void mutZ(int z) {
        this.z = z;
    }

    public final void mutX(double x) {
        this.x = (int)x;
    }

    public void mutZ(double z) {
        this.z = (int)z;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.x);
        stream.writeInt(this.z);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.x = stream.readInt();
        this.z = stream.readInt();
    }

    public MutableBlockVector2D nextPosition() {
        int absY;
        int absX = Math.abs(this.x);
        if (absX > (absY = Math.abs(this.z))) {
            if (this.x > 0) {
                return this.setComponents(this.x, this.z + 1);
            }
            return this.setComponents(this.x, this.z - 1);
        }
        if (absY > absX) {
            if (this.z > 0) {
                return this.setComponents(this.x - 1, this.z);
            }
            return this.setComponents(this.x + 1, this.z);
        }
        if (this.x == this.z && this.x > 0) {
            return this.setComponents(this.x, this.z + 1);
        }
        if (this.x == absX) {
            return this.setComponents(this.x, this.z + 1);
        }
        if (this.z == absY) {
            return this.setComponents(this.x, this.z - 1);
        }
        return this.setComponents(this.x + 1, this.z);
    }
}

