/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ZstdOutputStream
extends FilterOutputStream {
    private long stream = ZstdOutputStream.createCStream();
    private long srcPos = 0L;
    private long dstPos = 0L;
    private byte[] dst = new byte[dstSize];
    private boolean isClosed = false;
    private static final int dstSize;

    private static native long recommendedCOutSize();

    private static native long createCStream();

    private static native int freeCStream(long var0);

    private native int initCStream(long var1, int var3);

    private native int compressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    private native int flushStream(long var1, byte[] var3, int var4);

    private native int endStream(long var1, byte[] var3, int var4);

    public ZstdOutputStream(OutputStream outputStream, int n) throws IOException {
        super(outputStream);
        int n2 = this.initCStream(this.stream, n);
        if (Zstd.isError(n2)) {
            throw new IOException("Compression error: cannot create header: " + Zstd.getErrorName(n2));
        }
    }

    public ZstdOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        int n3 = n + n2;
        this.srcPos = n;
        while (this.srcPos < (long)n3) {
            int n4 = this.compressStream(this.stream, this.dst, dstSize, byArray, n3);
            if (Zstd.isError(n4)) {
                throw new IOException("Compression error: " + Zstd.getErrorName(n4));
            }
            if (this.dstPos <= 0L) continue;
            this.out.write(this.dst, 0, (int)this.dstPos);
        }
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    @Override
    public void flush() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        int n = this.flushStream(this.stream, this.dst, dstSize);
        if (Zstd.isError(n)) {
            throw new IOException("Compression error: " + Zstd.getErrorName(n));
        }
        this.out.write(this.dst, 0, (int)this.dstPos);
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        int n = this.endStream(this.stream, this.dst, dstSize);
        if (Zstd.isError(n)) {
            throw new IOException("Compression error: " + Zstd.getErrorName(n));
        }
        this.out.write(this.dst, 0, (int)this.dstPos);
        ZstdOutputStream.freeCStream(this.stream);
        this.out.close();
        this.isClosed = true;
    }

    static {
        Native.load();
        dstSize = (int)ZstdOutputStream.recommendedCOutSize();
    }
}

