/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.ReflectionUtils9;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sun.reflect.ConstructorAccessor;
import sun.reflect.FieldAccessor;
import sun.reflect.ReflectionFactory;

public class ReflectionUtils {
    private static Class<?> UNMODIFIABLE_MAP = Collections.unmodifiableMap(Collections.EMPTY_MAP).getClass();

    public static <T> T as(Class<T> t, Object o) {
        return t.isInstance(o) ? (T)t.cast(o) : null;
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName) {
        try {
            return ReflectionUtils.addEnum(enumType, enumName, new Class[0], new Object[0]);
        }
        catch (Throwable ignore) {
            return ReflectionUtils9.addEnum(enumType, enumName);
        }
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] additionalTypes, Object[] additionalValues) {
        Field[] fields;
        if (!Enum.class.isAssignableFrom(enumType)) {
            throw new RuntimeException("class " + enumType + " is not an instance of Enum");
        }
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            if (!field.getName().contains("$VALUES")) continue;
            valuesField = field;
            break;
        }
        AccessibleObject.setAccessible(new Field[]{valuesField}, true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
            Enum newValue = (Enum)ReflectionUtils.makeEnum(enumType, enumName, values.size(), additionalTypes, additionalValues);
            values.add(newValue);
            ReflectionUtils.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            ReflectionUtils.cleanEnumCache(enumType);
            return (T)newValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T extends Enum<?>> void clearEnum(Class<T> enumType) {
        Field[] fields;
        if (!Enum.class.isAssignableFrom(enumType)) {
            throw new RuntimeException("class " + enumType + " is not an instance of Enum");
        }
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            if (!field.getName().contains("$VALUES")) continue;
            valuesField = field;
            break;
        }
        AccessibleObject.setAccessible(new Field[]{valuesField}, true);
        try {
            ReflectionUtils.setFailsafeFieldValue(valuesField, null, Array.newInstance(enumType, 0));
            ReflectionUtils.cleanEnumCache(enumType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T extends Enum<?>> void copyEnum(T dest, String value, Class<?>[] additionalTypes, Object[] additionalValues) {
        try {
            Class<?> clazz = dest.getClass();
            Object newEnum = ReflectionUtils.makeEnum(clazz, value, dest.ordinal(), additionalTypes, additionalValues);
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                Object newValue = field.get(newEnum);
                ReflectionUtils.setField(field, dest, newValue);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static Object makeEnum(Class<?> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws Exception {
        Object[] parms = new Object[additionalValues.length + 2];
        parms[0] = value;
        parms[1] = ordinal;
        System.arraycopy(additionalValues, 0, parms, 2, additionalValues.length);
        return enumClass.cast(ReflectionUtils.getConstructorAccessor(enumClass, additionalTypes).newInstance(parms));
    }

    private static ConstructorAccessor getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws NoSuchMethodException {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return ReflectionFactory.getReflectionFactory().newConstructorAccessor(enumClass.getDeclaredConstructor(parameterTypes));
    }

    public static void setFailsafeFieldValue(Field field, Object target, Object value) throws NoSuchFieldException, IllegalAccessException {
        field.setAccessible(true);
        if (Modifier.isFinal(field.getModifiers())) {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            int modifiers = modifiersField.getInt(field);
            modifiersField.setInt(field, modifiers &= 0xFFFFFFEF);
        }
        try {
            FieldAccessor fa = ReflectionFactory.getReflectionFactory().newFieldAccessor(field, false);
            fa.set(target, value);
        }
        catch (NoSuchMethodError error) {
            field.set(target, value);
        }
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            AccessibleObject.setAccessible(new Field[]{field}, true);
            ReflectionUtils.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) throws NoSuchFieldException, IllegalAccessException {
        ReflectionUtils.blankField(enumClass, "enumConstantDirectory");
        ReflectionUtils.blankField(enumClass, "enumConstants");
    }

    public static <T, V> Map<T, V> getMap(Map<T, V> map) {
        try {
            Class<?> clazz = map.getClass();
            if (clazz != UNMODIFIABLE_MAP) {
                return map;
            }
            Field m = clazz.getDeclaredField("m");
            m.setAccessible(true);
            return (Map)m.get(map);
        }
        catch (Throwable e) {
            MainUtil.handleError(e);
            return map;
        }
    }

    public static <T> List<T> getList(List<T> list) {
        try {
            Class<?> clazz = Class.forName("java.util.Collections$UnmodifiableList");
            if (!clazz.isInstance(list)) {
                return list;
            }
            Field m = clazz.getDeclaredField("list");
            m.setAccessible(true);
            return (List)m.get(list);
        }
        catch (Throwable e) {
            MainUtil.handleError(e);
            return list;
        }
    }

    public static Object getHandle(Object wrapper) {
        Method getHandle = ReflectionUtils.makeMethod(wrapper.getClass(), "getHandle", new Class[0]);
        return ReflectionUtils.callMethod(getHandle, wrapper, new Object[0]);
    }

    public static Method makeMethod(Class<?> clazz, String methodName, Class<?> ... paramaters) {
        try {
            return clazz.getDeclaredMethod(methodName, paramaters);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T callMethod(Method method, Object instance, Object ... paramaters) {
        if (method == null) {
            throw new RuntimeException("No such method");
        }
        method.setAccessible(true);
        try {
            return (T)method.invoke(instance, paramaters);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> Constructor<T> makeConstructor(Class<?> clazz, Class<?> ... paramaterTypes) {
        try {
            return clazz.getConstructor(paramaterTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T callConstructor(Constructor<T> constructor, Object ... paramaters) {
        if (constructor == null) {
            throw new RuntimeException("No such constructor");
        }
        constructor.setAccessible(true);
        try {
            return constructor.newInstance(paramaters);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Field makeField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Field findField(Class<?> clazz, Class<?> type, int hasMods, int noMods) {
        for (Field field : clazz.getDeclaredFields()) {
            int mods;
            if (type != null && !type.isAssignableFrom(field.getType()) || ((mods = field.getModifiers()) & hasMods) != hasMods || (mods & noMods) != 0) continue;
            return ReflectionUtils.setAccessible(field);
        }
        return null;
    }

    public static Field findField(Class<?> clazz, Class<?> type) {
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != type) continue;
            return ReflectionUtils.setAccessible(field);
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, Class<?> returnType, Class ... params) {
        return ReflectionUtils.findMethod(clazz, 0, returnType, params);
    }

    public static Method findMethod(Class<?> clazz, int index, int hasMods, int noMods, Class<?> returnType, Class ... params) {
        block0: for (Method method : ReflectionUtils.sortMethods(clazz.getDeclaredMethods())) {
            if (returnType != null && method.getReturnType() != returnType) continue;
            Class<?>[] mp = method.getParameterTypes();
            int mods = method.getModifiers();
            if ((mods & hasMods) != hasMods || (mods & noMods) != 0) continue;
            if (params == null) {
                if (index-- != 0) continue;
                return ReflectionUtils.setAccessible(method);
            }
            if (mp.length != params.length) continue;
            for (int i = 0; i < mp.length; ++i) {
                if (mp[i] != params[i]) continue block0;
            }
            if (index-- != 0) continue;
            return ReflectionUtils.setAccessible(method);
        }
        return null;
    }

    public static Method[] sortMethods(Method[] methods) {
        Arrays.sort(methods, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        return methods;
    }

    public static Field[] sortFields(Field[] fields) {
        Arrays.sort(fields, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        return fields;
    }

    public static Method findMethod(Class<?> clazz, int index, Class<?> returnType, Class ... params) {
        return ReflectionUtils.findMethod(clazz, index, 0, 0, returnType, params);
    }

    public static <T extends AccessibleObject> T setAccessible(T ao) {
        ao.setAccessible(true);
        return ao;
    }

    public static <T> T getField(Field field, Object instance) {
        if (field == null) {
            throw new RuntimeException("No such field");
        }
        field.setAccessible(true);
        try {
            return (T)field.get(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setField(String fieldName, Object instance, Object value) {
        try {
            Field field = instance.getClass().getDeclaredField(fieldName);
            ReflectionUtils.setField(field, instance, value);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(Field field, Object instance, Object value) {
        if (field == null) {
            throw new RuntimeException("No such field");
        }
        field.setAccessible(true);
        try {
            field.set(instance, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static <T> Class<? extends T> getClass(String name, Class<T> superClass) {
        try {
            return Class.forName(name).asSubclass(superClass);
        }
        catch (ClassCastException | ClassNotFoundException ex) {
            return null;
        }
    }

    public static RefClass getRefClass(Class clazz) {
        return new RefClass(clazz);
    }

    public static class RefField {
        private final Field field;

        private RefField(Field field) {
            this.field = field;
            field.setAccessible(true);
        }

        public Field getRealField() {
            return this.field;
        }

        public RefClass getRefClass() {
            return new RefClass(this.field.getDeclaringClass());
        }

        public RefClass getFieldRefClass() {
            return new RefClass(this.field.getType());
        }

        public RefExecutor of(Object e) {
            return new RefExecutor(e);
        }

        public class RefExecutor {
            final Object e;

            public RefExecutor(Object e) {
                this.e = e;
            }

            public void set(Object param) {
                try {
                    RefField.this.field.set(this.e, param);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public Object get() {
                try {
                    return RefField.this.field.get(this.e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class RefConstructor {
        private final Constructor constructor;

        private RefConstructor(Constructor constructor) {
            this.constructor = constructor;
            constructor.setAccessible(true);
        }

        public Constructor getRealConstructor() {
            return this.constructor;
        }

        public RefClass getRefClass() {
            return new RefClass(this.constructor.getDeclaringClass());
        }

        public Object create(Object ... params) {
            try {
                return this.constructor.newInstance(params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class RefMethod {
        private final Method method;

        private RefMethod(Method method) {
            this.method = method;
            method.setAccessible(true);
        }

        public Method getRealMethod() {
            return this.method;
        }

        public RefClass getRefClass() {
            return new RefClass(this.method.getDeclaringClass());
        }

        public RefClass getReturnRefClass() {
            return new RefClass(this.method.getReturnType());
        }

        public RefExecutor of(Object e) {
            return new RefExecutor(e);
        }

        public Object call(Object ... params) {
            try {
                return this.method.invoke(null, params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public class RefExecutor {
            final Object e;

            public RefExecutor(Object e) {
                this.e = e;
            }

            public Object call(Object ... params) {
                try {
                    return RefMethod.this.method.invoke(this.e, params);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class RefClass {
        private final Class<?> clazz;

        private RefClass(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getRealClass() {
            return this.clazz;
        }

        public boolean isInstance(Object object) {
            return this.clazz.isInstance(object);
        }

        public RefMethod getMethod(String name, Object ... types) throws NoSuchMethodException {
            try {
                Class[] classes = new Class[types.length];
                int i = 0;
                for (Object e : types) {
                    classes[i++] = e instanceof Class ? (Class)e : (e instanceof RefClass ? ((RefClass)e).getRealClass() : e.getClass());
                }
                try {
                    return new RefMethod(this.clazz.getMethod(name, classes));
                }
                catch (NoSuchMethodException ignored) {
                    return new RefMethod(this.clazz.getDeclaredMethod(name, classes));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public RefConstructor getConstructor(Object ... types) {
            try {
                Class[] classes = new Class[types.length];
                int i = 0;
                for (Object e : types) {
                    classes[i++] = e instanceof Class ? (Class)e : (e instanceof RefClass ? ((RefClass)e).getRealClass() : e.getClass());
                }
                try {
                    return new RefConstructor(this.clazz.getConstructor(classes));
                }
                catch (NoSuchMethodException ignored) {
                    return new RefConstructor(this.clazz.getDeclaredConstructor(classes));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public RefMethod findMethod(Object ... types) {
            Object[] classes = new Class[types.length];
            int t = 0;
            for (Object e : types) {
                classes[t++] = e instanceof Class ? (Class)e : (e instanceof RefClass ? ((RefClass)e).getRealClass() : e.getClass());
            }
            ArrayList methods = new ArrayList();
            Collections.addAll(methods, this.clazz.getMethods());
            Collections.addAll(methods, this.clazz.getDeclaredMethods());
            for (Method m : methods) {
                Object[] objectArray;
                int n;
                int n2;
                Object[] methodTypes = m.getParameterTypes();
                if (methodTypes.length != classes.length || (n2 = 0) >= (n = (objectArray = classes).length)) continue;
                Class aClass = objectArray[n2];
                if (!Arrays.equals(classes, methodTypes)) continue;
                return new RefMethod(m);
            }
            throw new RuntimeException("no such method");
        }

        public RefMethod findMethodByName(String ... names) {
            ArrayList methods = new ArrayList();
            Collections.addAll(methods, this.clazz.getMethods());
            Collections.addAll(methods, this.clazz.getDeclaredMethods());
            for (Method m : methods) {
                for (String name : names) {
                    if (!m.getName().equals(name)) continue;
                    return new RefMethod(m);
                }
            }
            throw new RuntimeException("no such method");
        }

        public RefMethod findMethodByReturnType(RefClass type) {
            return this.findMethodByReturnType(type.clazz);
        }

        public RefMethod findMethodByReturnType(Class type) {
            if (type == null) {
                type = Void.TYPE;
            }
            ArrayList methods = new ArrayList();
            Collections.addAll(methods, this.clazz.getMethods());
            Collections.addAll(methods, this.clazz.getDeclaredMethods());
            for (Method m : methods) {
                if (!type.equals(m.getReturnType())) continue;
                return new RefMethod(m);
            }
            throw new RuntimeException("no such method");
        }

        public RefConstructor findConstructor(int number) {
            ArrayList constructors = new ArrayList();
            Collections.addAll(constructors, this.clazz.getConstructors());
            Collections.addAll(constructors, this.clazz.getDeclaredConstructors());
            for (Constructor m : constructors) {
                if (m.getParameterTypes().length != number) continue;
                return new RefConstructor(m);
            }
            throw new RuntimeException("no such constructor");
        }

        public RefField getField(String name) {
            try {
                try {
                    return new RefField(this.clazz.getField(name));
                }
                catch (NoSuchFieldException ignored) {
                    return new RefField(this.clazz.getDeclaredField(name));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public RefField findField(RefClass type) {
            return this.findField(type.clazz);
        }

        public RefField findField(Class type) {
            if (type == null) {
                type = Void.TYPE;
            }
            ArrayList fields = new ArrayList();
            Collections.addAll(fields, this.clazz.getFields());
            Collections.addAll(fields, this.clazz.getDeclaredFields());
            for (Field f : fields) {
                if (!type.equals(f.getType())) continue;
                return new RefField(f);
            }
            throw new RuntimeException("no such field");
        }
    }
}

