/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import java.io.DataOutput;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;

public final class IOUtil {
    public InputStream toInputStream(URI uri) throws IOException {
        String scheme = uri.getScheme();
        switch (scheme.toLowerCase()) {
            case "file": {
                return new FileInputStream(uri.getPath());
            }
            case "http": 
            case "https": {
                return uri.toURL().openStream();
            }
        }
        return null;
    }

    public static final int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static final void writeInt(OutputStream out, int v) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
    }

    public static final void writeVarInt(OutputStream out, int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            out.write(i & 0x7F | 0x80);
            i >>>= 7;
        }
        out.write(i);
    }

    public static final int readVarInt(InputStream in) throws IOException {
        int b;
        int i = 0;
        int offset = 0;
        while ((b = in.read()) > 127) {
            i |= b - 128 << offset;
            offset += 7;
        }
        return i |= b << offset;
    }

    public static final void copy(InputStream in, OutputStream out) throws IOException {
        int r;
        byte[] buf = new byte[8192];
        while ((r = in.read(buf)) != -1) {
            out.write(buf, 0, r);
        }
    }

    public static final int copy(InputStream in, OutputStream out, int len) throws IOException {
        int r;
        byte[] buf = new byte[8192];
        while (len > 0 && (r = in.read(buf, 0, Math.min(buf.length, len))) != -1) {
            len -= r;
            out.write(buf, 0, r);
        }
        return len;
    }

    public static final void copy(InputStream in, DataOutput out) throws IOException {
        int r;
        byte[] buf = new byte[8192];
        while ((r = in.read(buf)) != -1) {
            out.write(buf, 0, r);
        }
    }
}

