/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.logging.rollback.RollbackOptimizedHistory;
import com.boydti.fawe.object.FaweLimit;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.NullChangeSet;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.changeset.DiskStorageHistory;
import com.boydti.fawe.object.changeset.FaweChangeSet;
import com.boydti.fawe.object.changeset.MemoryOptimizedHistory;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.eventbus.EventBus;
import com.sk89q.worldedit.world.World;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EditSessionBuilder {
    private World world;
    private String worldName;
    private FaweQueue queue;
    private FawePlayer player;
    private FaweLimit limit;
    private FaweChangeSet changeSet;
    private Region[] allowedRegions;
    private Boolean autoQueue;
    private Boolean fastmode;
    private Boolean checkMemory;
    private Boolean combineStages;
    private EventBus eventBus;
    private BlockBag blockBag;
    private EditSessionEvent event;

    public EditSessionBuilder(@Nonnull World world) {
        Preconditions.checkNotNull((Object)world);
        this.world = world;
        this.worldName = Fawe.imp().getWorldName(world);
    }

    public EditSessionBuilder(@Nonnull String worldName) {
        Preconditions.checkNotNull((Object)worldName);
        this.worldName = worldName;
        this.world = FaweAPI.getWorld(worldName);
    }

    public EditSessionBuilder player(@Nullable FawePlayer player) {
        this.player = player;
        return this;
    }

    public EditSessionBuilder limit(@Nullable FaweLimit limit) {
        this.limit = limit;
        return this;
    }

    public EditSessionBuilder limitUnlimited() {
        return this.limit(FaweLimit.MAX.copy());
    }

    public EditSessionBuilder limitUnprocessed(@Nonnull FawePlayer fp) {
        Preconditions.checkNotNull((Object)fp);
        this.limitUnlimited();
        FaweLimit tmp = fp.getLimit();
        this.limit.INVENTORY_MODE = tmp.INVENTORY_MODE;
        return this;
    }

    public EditSessionBuilder changeSet(@Nullable FaweChangeSet changeSet) {
        this.changeSet = changeSet;
        return this;
    }

    public EditSessionBuilder changeSetNull() {
        return this.changeSet(this.world == null ? new NullChangeSet(this.worldName) : new NullChangeSet(this.world));
    }

    public EditSessionBuilder world(@Nonnull World world) {
        Preconditions.checkNotNull((Object)world);
        this.world = world;
        this.worldName = Fawe.imp().getWorldName(world);
        return this;
    }

    public EditSessionBuilder changeSet(boolean disk, @Nullable UUID uuid, int compression) {
        this.changeSet = this.world == null ? (disk ? (Settings.IMP.HISTORY.USE_DATABASE ? new RollbackOptimizedHistory(this.worldName, uuid) : new DiskStorageHistory(this.worldName, uuid)) : new MemoryOptimizedHistory(this.worldName)) : (disk ? (Settings.IMP.HISTORY.USE_DATABASE ? new RollbackOptimizedHistory(this.world, uuid) : new DiskStorageHistory(this.world, uuid)) : new MemoryOptimizedHistory(this.world));
        return this;
    }

    public EditSessionBuilder allowedRegions(@Nullable Region[] allowedRegions) {
        this.allowedRegions = allowedRegions;
        return this;
    }

    @Deprecated
    public EditSessionBuilder allowedRegions(@Nullable RegionWrapper[] allowedRegions) {
        this.allowedRegions = allowedRegions;
        return this;
    }

    public EditSessionBuilder allowedRegions(@Nullable RegionWrapper allowedRegion) {
        this.allowedRegions = allowedRegion == null ? null : allowedRegion.toArray();
        return this;
    }

    public EditSessionBuilder allowedRegionsEverywhere() {
        return this.allowedRegions(new Region[]{RegionWrapper.GLOBAL()});
    }

    public EditSessionBuilder autoQueue(@Nullable Boolean autoQueue) {
        this.autoQueue = autoQueue;
        return this;
    }

    public EditSessionBuilder fastmode(@Nullable Boolean fastmode) {
        this.fastmode = fastmode;
        return this;
    }

    public EditSessionBuilder checkMemory(@Nullable Boolean checkMemory) {
        this.checkMemory = checkMemory;
        return this;
    }

    public EditSessionBuilder combineStages(@Nullable Boolean combineStages) {
        this.combineStages = combineStages;
        return this;
    }

    public EditSessionBuilder queue(@Nullable FaweQueue queue) {
        this.queue = queue;
        return this;
    }

    public EditSessionBuilder blockBag(@Nullable BlockBag blockBag) {
        this.blockBag = blockBag;
        return this;
    }

    public EditSessionBuilder eventBus(@Nullable EventBus eventBus) {
        this.eventBus = eventBus;
        return this;
    }

    public EditSessionBuilder event(@Nullable EditSessionEvent event) {
        this.event = event;
        return this;
    }

    public EditSession build() {
        return new EditSession(this.worldName, this.world, this.queue, this.player, this.limit, this.changeSet, this.allowedRegions, this.autoQueue, this.fastmode, this.checkMemory, this.combineStages, this.blockBag, this.eventBus, this.event);
    }
}

