/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.regions.general.plot;

import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.TaskManager;
import com.intellectualcrafters.plot.object.ChunkLoc;
import com.intellectualcrafters.plot.object.Location;
import com.intellectualcrafters.plot.object.Plot;
import com.intellectualcrafters.plot.util.ChunkManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.World;

public class FaweChunkManager
extends ChunkManager {
    private ChunkManager parent;

    public FaweChunkManager(ChunkManager parent) {
        this.parent = parent;
    }

    public int[] countEntities(Plot plot) {
        return this.parent.countEntities(plot);
    }

    public boolean loadChunk(String world, ChunkLoc loc, boolean force) {
        return this.parent.loadChunk(world, loc, force);
    }

    public void unloadChunk(String world, ChunkLoc loc, boolean save, boolean safe) {
        this.parent.unloadChunk(world, loc, save, safe);
    }

    public void clearAllEntities(Location pos1, Location pos2) {
        this.parent.clearAllEntities(pos1, pos2);
    }

    public void swap(final Location pos1, final Location pos2, final Location pos3, final Location pos4, final Runnable whenDone) {
        TaskManager.IMP.async(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<FaweChunkManager> clazz = FaweChunkManager.class;
                synchronized (FaweChunkManager.class) {
                    EditSession sessionA = new EditSessionBuilder(pos1.getWorld()).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
                    EditSession sessionB = new EditSessionBuilder(pos3.getWorld()).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
                    CuboidRegion regionA = new CuboidRegion(new Vector(pos1.getX(), pos1.getY(), pos1.getZ()), new Vector(pos2.getX(), pos2.getY(), pos2.getZ()));
                    CuboidRegion regionB = new CuboidRegion(new Vector(pos3.getX(), pos3.getY(), pos3.getZ()), new Vector(pos4.getX(), pos4.getY(), pos4.getZ()));
                    ForwardExtentCopy copyA = new ForwardExtentCopy(sessionA, regionA, sessionB, regionB.getMinimumPoint());
                    ForwardExtentCopy copyB = new ForwardExtentCopy(sessionB, regionB, sessionA, regionA.getMinimumPoint());
                    try {
                        Operations.completeLegacy(copyA);
                        Operations.completeLegacy(copyB);
                        sessionA.flushQueue();
                        sessionB.flushQueue();
                    }
                    catch (MaxChangedBlocksException e) {
                        e.printStackTrace();
                    }
                    TaskManager.IMP.task(whenDone);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public boolean copyRegion(final Location pos1, final Location pos2, final Location pos3, final Runnable whenDone) {
        TaskManager.IMP.async(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<FaweChunkManager> clazz = FaweChunkManager.class;
                synchronized (FaweChunkManager.class) {
                    EditSession from = new EditSessionBuilder(pos1.getWorld()).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
                    EditSession to = new EditSessionBuilder(pos3.getWorld()).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
                    CuboidRegion region = new CuboidRegion(new Vector(pos1.getX(), pos1.getY(), pos1.getZ()), new Vector(pos2.getX(), pos2.getY(), pos2.getZ()));
                    ForwardExtentCopy copy = new ForwardExtentCopy(from, region, to, new Vector(pos3.getX(), pos3.getY(), pos3.getZ()));
                    try {
                        Operations.completeLegacy(copy);
                        to.flushQueue();
                    }
                    catch (MaxChangedBlocksException e) {
                        e.printStackTrace();
                    }
                    TaskManager.IMP.task(whenDone);
                    return;
                }
            }
        });
        return true;
    }

    public boolean regenerateRegion(final Location pos1, final Location pos2, boolean ignore, final Runnable whenDone) {
        TaskManager.IMP.async(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<FaweChunkManager> clazz = FaweChunkManager.class;
                synchronized (FaweChunkManager.class) {
                    EditSession editSession = new EditSessionBuilder(pos1.getWorld()).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
                    World world = editSession.getWorld();
                    CuboidRegion region = new CuboidRegion(new Vector(pos1.getX(), pos1.getY(), pos1.getZ()), new Vector(pos2.getX(), pos2.getY(), pos2.getZ()));
                    world.regenerate(region, editSession);
                    editSession.flushQueue();
                    TaskManager.IMP.task(whenDone);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        return true;
    }
}

