/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.visitor;

import com.boydti.fawe.config.Settings;
import com.boydti.fawe.example.MappedFaweQueue;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.util.ExtentTraverser;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.extent.Extent;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Fast2DIterator
implements Iterable<Vector2D> {
    private final Iterable<? extends Vector2D> iterable;
    private final MappedFaweQueue queue;

    public Fast2DIterator(@Nonnull Iterable<? extends Vector2D> iter, @Nullable EditSession extent) {
        this(iter, (HasFaweQueue)extent);
    }

    public Fast2DIterator(@Nonnull Iterable<? extends Vector2D> iter, @Nullable Extent extent) {
        this(iter, (HasFaweQueue)(extent != null ? (extent instanceof HasFaweQueue ? extent : new ExtentTraverser<Extent>(extent).findAndGet(HasFaweQueue.class)) : null));
    }

    public Fast2DIterator(@Nonnull Iterable<? extends Vector2D> iter, @Nullable HasFaweQueue editSession) {
        this(iter, editSession != null ? editSession.getQueue() : null);
    }

    public Fast2DIterator(@Nonnull Iterable<? extends Vector2D> iter, @Nullable FaweQueue faweQueue) {
        this.iterable = iter;
        this.queue = faweQueue != null && faweQueue instanceof MappedFaweQueue ? (MappedFaweQueue)faweQueue : null;
    }

    public Iterable<? extends Vector2D> getIterable() {
        return this.iterable;
    }

    @Override
    public Iterator<Vector2D> iterator() {
        if (this.queue == null || Settings.IMP.QUEUE.PRELOAD_CHUNKS <= 1) {
            return this.iterable.iterator();
        }
        return new Iterator<Vector2D>(){
            Iterator<? extends Vector2D> trailIter;
            Iterator<? extends Vector2D> leadIter;
            int lastTrailChunkX;
            int lastTrailChunkZ;
            int lastLeadChunkX;
            int lastLeadChunkZ;
            int loadingTarget;
            int cx;
            int cz;
            {
                this.trailIter = Fast2DIterator.this.iterable.iterator();
                this.leadIter = Fast2DIterator.this.iterable.iterator();
                this.lastTrailChunkX = Integer.MIN_VALUE;
                this.lastTrailChunkZ = Integer.MIN_VALUE;
                this.lastLeadChunkX = Integer.MIN_VALUE;
                this.lastLeadChunkZ = Integer.MIN_VALUE;
                this.loadingTarget = Settings.IMP.QUEUE.PRELOAD_CHUNKS;
            }

            @Override
            public void remove() {
                this.trailIter.remove();
            }

            @Override
            public boolean hasNext() {
                return this.trailIter.hasNext();
            }

            @Override
            public Vector2D next() {
                Vector2D pt = this.trailIter.next();
                this.lastTrailChunkX = pt.getBlockX() >> 4;
                if ((this.lastTrailChunkX != this.lastTrailChunkX || (this.lastTrailChunkZ = pt.getBlockZ() >> 4) != this.lastTrailChunkZ) && this.leadIter.hasNext()) {
                    try {
                        int amount;
                        if (this.lastLeadChunkX == Integer.MIN_VALUE) {
                            this.lastLeadChunkX = this.cx;
                            this.lastLeadChunkZ = this.cz;
                            amount = this.loadingTarget;
                        } else {
                            amount = 1;
                        }
                        int count = 0;
                        while (count < amount) {
                            Vector2D v = this.leadIter.next();
                            int vcx = v.getBlockX() >> 4;
                            int vcz = v.getBlockZ() >> 4;
                            if (vcx == this.lastLeadChunkX && vcz == this.lastLeadChunkZ) continue;
                            this.lastLeadChunkX = vcx;
                            this.lastLeadChunkZ = vcz;
                            Fast2DIterator.this.queue.queueChunkLoad(vcx, vcz);
                            ++count;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return pt;
            }
        };
    }
}

