/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.task;

import com.boydti.fawe.object.task.AsyncNotifyQueue;
import com.boydti.fawe.util.TaskManager;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SimpleAsyncNotifyQueue
extends AsyncNotifyQueue {
    private ConcurrentLinkedQueue<Runnable> tasks = new ConcurrentLinkedQueue();
    private Thread.UncaughtExceptionHandler handler;

    public SimpleAsyncNotifyQueue(Thread.UncaughtExceptionHandler handler) {
        this.handler = handler;
    }

    @Override
    public boolean hasQueued() {
        return !this.tasks.isEmpty();
    }

    @Override
    public void operate() {
        while (!this.tasks.isEmpty()) {
            Runnable task = this.tasks.poll();
            try {
                if (task == null) continue;
                task.run();
            }
            catch (Throwable e) {
                if (this.handler == null) continue;
                this.handler.uncaughtException(Thread.currentThread(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queue(Runnable queueTask) {
        Object object = this.lock;
        synchronized (object) {
            if (queueTask != null) {
                this.tasks.add(queueTask);
            }
            if (!this.running.get()) {
                this.running.set(true);
                TaskManager.IMP.async(this.task);
            }
        }
    }

    public int getSize() {
        return this.tasks.size();
    }

    public void clear() {
        this.tasks.clear();
    }
}

