/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.boydti.fawe.object.PseudoRandom;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.BreadthFirstSearch;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.IOException;
import java.io.ObjectInputStream;

public class SurfaceRandomOffsetPattern
extends AbstractPattern {
    private final Pattern pattern;
    private int moves;
    private transient MutableBlockVector cur;
    private transient MutableBlockVector[] buffer;
    private transient MutableBlockVector[] allowed;
    private transient MutableBlockVector next;

    public SurfaceRandomOffsetPattern(Pattern pattern, int distance) {
        this.pattern = pattern;
        this.moves = Math.min(255, distance);
        this.init();
    }

    private void init() {
        this.cur = new MutableBlockVector();
        this.buffer = new MutableBlockVector[BreadthFirstSearch.DIAGONAL_DIRECTIONS.length];
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = new MutableBlockVector();
        }
        this.allowed = new MutableBlockVector[this.buffer.length];
    }

    @Override
    public BlockStateHolder apply(Vector position) {
        return this.pattern.apply(this.travel(position));
    }

    private Vector travel(Vector pos) {
        this.cur.setComponents(pos);
        for (int move = 0; move < this.moves; ++move) {
            int index = 0;
            for (int i = 0; i < this.allowed.length; ++i) {
                this.next = this.buffer[i];
                Vector dir = BreadthFirstSearch.DIAGONAL_DIRECTIONS[i];
                this.next.setComponents(this.cur.getBlockX() + dir.getBlockX(), this.cur.getBlockY() + dir.getBlockY(), this.cur.getBlockZ() + dir.getBlockZ());
                if (!this.allowed(this.next)) continue;
                this.allowed[index++] = this.next;
            }
            if (index == 0) {
                return this.cur;
            }
            this.next = this.allowed[PseudoRandom.random.nextInt(index)];
            this.cur.setComponents(this.next.getBlockX(), this.next.getBlockY(), this.next.getBlockZ());
        }
        return this.cur;
    }

    private boolean allowed(Vector v) {
        BlockStateHolder block = this.pattern.apply(v);
        if (!block.getBlockType().getMaterial().isMovementBlocker()) {
            return false;
        }
        int x = v.getBlockX();
        int y = v.getBlockY();
        int z = v.getBlockZ();
        v.mutY(y + 1);
        if (this.canPassthrough(v)) {
            v.mutY(y);
            return true;
        }
        v.mutY(y - 1);
        if (this.canPassthrough(v)) {
            v.mutY(y);
            return true;
        }
        v.mutY(y);
        v.mutX(x + 1);
        if (this.canPassthrough(v)) {
            v.mutX(x);
            return true;
        }
        v.mutX(x - 1);
        if (this.canPassthrough(v)) {
            v.mutX(x);
            return true;
        }
        v.mutX(x);
        v.mutZ(z + 1);
        if (this.canPassthrough(v)) {
            v.mutZ(z);
            return true;
        }
        v.mutZ(z - 1);
        if (this.canPassthrough(v)) {
            v.mutZ(z);
            return true;
        }
        v.mutZ(z);
        return false;
    }

    private boolean canPassthrough(Vector v) {
        BlockStateHolder block = this.pattern.apply(v);
        return !block.getBlockType().getMaterial().isMovementBlocker();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.init();
    }
}

