/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.mask;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.Mask;

public class WallMask
extends AbstractMask {
    private final int min;
    private final int max;
    private final Mask mask;

    public WallMask(Mask mask, int requiredMin, int requiredMax) {
        this.mask = mask;
        this.min = requiredMin;
        this.max = requiredMax;
    }

    @Override
    public boolean test(Vector v) {
        int count = 0;
        double x = v.getX();
        double y = v.getY();
        double z = v.getZ();
        v.mutX(x + 1.0);
        if (this.mask.test(v) && ++count == this.min && this.max >= 8) {
            v.mutX(x);
            return true;
        }
        v.mutX(x - 1.0);
        if (this.mask.test(v) && ++count == this.min && this.max >= 8) {
            v.mutX(x);
            return true;
        }
        v.mutX(x);
        v.mutZ(z + 1.0);
        if (this.mask.test(v) && ++count == this.min && this.max >= 8) {
            v.mutZ(z);
            return true;
        }
        v.mutZ(z - 1.0);
        if (this.mask.test(v) && ++count == this.min && this.max >= 8) {
            v.mutZ(z);
            return true;
        }
        v.mutZ(z);
        return count >= this.min && count <= this.max;
    }
}

