/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.mask;

import com.boydti.fawe.object.extent.LightingExtent;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.Mask2D;
import javax.annotation.Nullable;

public class BlockLightMask
extends AbstractExtentMask {
    private final int min;
    private final int max;

    public BlockLightMask(Extent extent, int min, int max) {
        super(extent);
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean test(Vector vector) {
        Extent extent = this.getExtent();
        if (extent instanceof LightingExtent) {
            int light = ((LightingExtent)extent).getBlockLight(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
            return light >= this.min && light <= this.max;
        }
        return false;
    }

    @Override
    @Nullable
    public Mask2D toMask2D() {
        return null;
    }
}

