/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.NbtValued;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Set;
import javax.annotation.Nullable;

public class StripNBTExtent
extends AbstractDelegateExtent {
    private final String[] strip;

    public StripNBTExtent(Extent extent, Set<String> strip) {
        super(extent);
        this.strip = strip.toArray(new String[strip.size()]);
    }

    @Override
    public boolean setBlock(Vector location, BlockStateHolder block) throws WorldEditException {
        return super.setBlock(location, this.stripNBT(block));
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        return super.setBlock(x, y, z, this.stripNBT(block));
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        return super.createEntity(location, this.stripNBT(entity));
    }

    public <T extends NbtValued> T stripNBT(T block) {
        if (!block.hasNbtData()) {
            return block;
        }
        CompoundTag nbt = block.getNbtData();
        Object value = nbt.getValue();
        for (String key : this.strip) {
            value.remove(key);
        }
        return block;
    }
}

