/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.boydti.fawe.object.extent.ResettableExtent;
import com.sk89q.worldedit.MutableBlockVector2D;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.SplittableRandom;

public class RandomOffsetTransform
extends ResettableExtent {
    private transient SplittableRandom random;
    private transient MutableBlockVector2D mutable = new MutableBlockVector2D();
    private final int dx;
    private final int dy;
    private final int dz;

    public RandomOffsetTransform(Extent parent, int dx, int dy, int dz) {
        super(parent);
        this.dx = dx + 1;
        this.dy = dy + 1;
        this.dz = dz + 1;
        this.random = new SplittableRandom();
    }

    @Override
    public boolean setBiome(Vector2D pos, BaseBiome biome) {
        int x = pos.getBlockX() + this.random.nextInt(1 + (this.dx << 1)) - this.dx;
        int z = pos.getBlockZ() + this.random.nextInt(1 + (this.dz << 1)) - this.dz;
        return this.getExtent().setBiome(this.mutable.setComponents(x, z), biome);
    }

    @Override
    public boolean setBlock(Vector pos, BlockStateHolder block) throws WorldEditException {
        int x = pos.getBlockX() + this.random.nextInt(1 + (this.dx << 1)) - this.dx;
        int y = pos.getBlockY() + this.random.nextInt(1 + (this.dy << 1)) - this.dy;
        int z = pos.getBlockZ() + this.random.nextInt(1 + (this.dz << 1)) - this.dz;
        return this.getExtent().setBlock(x, y, z, block);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        x = x + this.random.nextInt(1 + (this.dx << 1)) - this.dx;
        y = y + this.random.nextInt(1 + (this.dy << 1)) - this.dy;
        z = z + this.random.nextInt(1 + (this.dz << 1)) - this.dz;
        return this.getExtent().setBlock(x, y, z, block);
    }

    @Override
    public ResettableExtent setExtent(Extent extent) {
        this.random = new SplittableRandom();
        this.mutable = new MutableBlockVector2D();
        return super.setExtent(extent);
    }
}

