/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.boydti.fawe.object.FaweLimit;
import com.boydti.fawe.object.extent.FaweRegionExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.regions.Region;
import java.util.Arrays;
import java.util.Collection;

public class MultiRegionExtent
extends FaweRegionExtent {
    private Region region;
    private final Region[] regions;
    private int index = 0;

    public MultiRegionExtent(Extent extent, FaweLimit limit, Region[] regions) {
        super(extent, limit);
        this.region = regions[0];
        this.regions = regions;
    }

    @Override
    public boolean contains(int x, int y, int z) {
        if (this.region.contains(x, y, z)) {
            return true;
        }
        for (int i = 0; i < this.regions.length; ++i) {
            Region current;
            if (i == this.index || !(current = this.regions[i]).contains(x, y, z)) continue;
            this.region = current;
            this.index = i;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(int x, int z) {
        if (this.region.contains(x, z)) {
            return true;
        }
        for (int i = 0; i < this.regions.length; ++i) {
            Region current;
            if (i == this.index || !(current = this.regions[i]).contains(x, z)) continue;
            this.region = current;
            this.index = i;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Region> getRegions() {
        return Arrays.asList(this.regions);
    }
}

