/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import java.util.Arrays;

public class ExtentHeightCacher
extends AbstractDelegateExtent {
    private transient int cacheCenX;
    private transient int cacheCenZ;
    private transient int cacheBotX = Integer.MIN_VALUE;
    private transient int cacheBotZ = Integer.MIN_VALUE;
    private transient int cacheCenterZ;
    private transient byte[] cacheHeights;
    private transient int lastY;
    private transient boolean foundY;
    private transient boolean lastValue;

    public ExtentHeightCacher(Extent extent) {
        super(extent);
    }

    public void reset() {
        this.cacheBotX = Integer.MIN_VALUE;
        this.cacheBotZ = Integer.MIN_VALUE;
        if (this.cacheHeights != null) {
            Arrays.fill(this.cacheHeights, (byte)0);
        }
    }

    @Override
    public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY) {
        int index;
        int rx = x - this.cacheBotX + 16;
        int rz = z - this.cacheBotZ + 16;
        if ((rx & 0xFF) != rx || (rz & 0xFF) != rz) {
            this.cacheBotX = x - 16;
            this.cacheBotZ = z - 16;
            this.lastY = y;
            rx = x - this.cacheBotX + 16;
            rz = z - this.cacheBotZ + 16;
            index = rx + (rz << 8);
            if (this.cacheHeights == null) {
                this.cacheHeights = new byte[65536];
            } else {
                Arrays.fill(this.cacheHeights, (byte)0);
            }
        } else {
            index = rx + (rz << 8);
        }
        int result = this.cacheHeights[index] & 0xFF;
        if (result == 0) {
            result = this.lastY = super.getNearestSurfaceTerrainBlock(x, z, this.lastY, minY, maxY);
            this.cacheHeights[index] = (byte)this.lastY;
        }
        return result;
    }
}

